/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant;

import com.kodaro.tenant.BInvoice;
import com.kodaro.tenant.BSuite;
import com.kodaro.tenant.util.BTbsObject;
import javax.baja.agent.BPxView;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BInvoices
extends BTbsObject {
    public static final String PX = "module://kodarotenant/px/";
    public static final Property Invoices = BInvoices.newProperty((int)0, (BValue)new BPxView(BOrd.make((String)"module://kodarotenant/px/Invoices.px")), null);
    public static final Property OwnerInvoices = BInvoices.newProperty((int)0, (BValue)new BPxView(BOrd.make((String)"module://kodarotenant/px/OwnerInvoices.px")), null);
    public static final Action newInvoice = BInvoices.newAction((int)2052, null);
    public static final Action poll = BInvoices.newAction((int)2068, null);
    public static final Type TYPE = Sys.loadType(BInvoices.class);

    public BPxView getInvoices() {
        return (BPxView)this.get(Invoices);
    }

    public void setInvoices(BPxView v) {
        this.set(Invoices, (BValue)v, null);
    }

    public BPxView getOwnerInvoices() {
        return (BPxView)this.get(OwnerInvoices);
    }

    public void setOwnerInvoices(BPxView v) {
        this.set(OwnerInvoices, (BValue)v, null);
    }

    public void newInvoice() {
        this.invoke(newInvoice, null, null);
    }

    @Override
    public void poll() {
        this.invoke(poll, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public BPollFrequency getPollFrequency() {
        return BPollFrequency.slow;
    }

    public void doNewInvoice() {
        BSuite suite = (BSuite)this.getParent();
        suite.invoice();
    }

    public void doPoll(Context cx) {
        long months = this.getTenant().getInvoiceRetentionMonths();
        long l = months * 2678400000L;
        BRelTime time = BRelTime.make((long)(months * 86400000L * 31L));
        BAbsTime oldest = Clock.time().subtract(time);
        Array toRemove = new Array(Property.class);
        SlotCursor c = this.getProperties();
        while (c.next(BInvoice.class)) {
            BInvoice i = (BInvoice)c.get();
            if (!i.getEnd().isBefore(oldest)) continue;
            toRemove.add((Object)c.property());
        }
        if (toRemove.size() > 0) {
            Property[] props = (Property[])toRemove.trim();
            int i = props.length;
            while (--i >= 0) {
                this.remove(props[i]);
            }
            BSuite suite = (BSuite)this.getParent();
            suite.clearOldHistory(oldest, cx);
        }
        BAbsTime now = Clock.time();
        if (this.getTenant().getAutoInvoice() && now.isAfter(this.getTenant().getNextInvoice().toAbsTime())) {
            this.getTenant().autoInvoiceNow();
        }
    }
}

