/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant;

import com.kodaro.tenant.BInvoiceRecord;
import com.kodaro.tenant.BOverrideEvent;
import com.kodaro.tenant.BSuite;
import com.kodaro.tenant.util.BTbsObject;
import java.util.Vector;
import javax.baja.agent.BPxView;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.history.BCapacity;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BMonth;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public abstract class BMeter
extends BTbsObject {
    public static final String PX = "module://kodarotenant/px/";
    public static final Property title = BMeter.newProperty((int)256, (String)"Lights/AC/Electricity...", null);
    public static final Property description = BMeter.newProperty((int)0, (String)"", null);
    public static final Property wholeQuantities = BMeter.newProperty((int)256, (boolean)false, null);
    public static final Property unitSymbol = BMeter.newProperty((int)256, (String)"Hr", null);
    public static final Property active = BMeter.newProperty((int)259, (boolean)false, null);
    public static final Property activityBegan = BMeter.newProperty((int)257, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showTimeZone", (BIDataValue)BBoolean.FALSE));
    public static final Property user = BMeter.newProperty((int)259, (String)"", null);
    public static final Property currentCharges = BMeter.newProperty((int)257, (int)0, (BFacets)BFacets.make((String)"precision", (BIDataValue)BDouble.make((double)2.0)));
    public static final Property currentConsumption = BMeter.newProperty((int)257, (int)0, (BFacets)BFacets.make((String)"precision", (BIDataValue)BDouble.make((double)2.0)));
    public static final Property currentConsumptionMax = BMeter.newProperty((int)259, (int)2, (BFacets)BFacets.make((String)"precision", (BIDataValue)BDouble.make((double)0.0)));
    public static final Property invoiceConsumption = BMeter.newProperty((int)257, (double)0.0, (BFacets)BFacets.make((String)"precision", (BIDataValue)BDouble.make((double)2.0)));
    public static final Property invoiceConsumptionMax = BMeter.newProperty((int)259, (int)2, (BFacets)BFacets.make((String)"precision", (BIDataValue)BDouble.make((double)0.0)));
    public static final Property invoiceCharges = BMeter.newProperty((int)257, (double)0.0, (BFacets)BFacets.make((String)"precision", (BIDataValue)BDouble.make((double)2.0)));
    public static final Property invoiceSubtotal = BMeter.newProperty((int)257, (double)0.0, (BFacets)BFacets.make((String)"precision", (BIDataValue)BDouble.make((double)2.0)));
    public static final Property rate = BMeter.newProperty((int)257, (double)0.0, (BFacets)BFacets.make((String)"precision", (BIDataValue)BDouble.make((double)5.0)));
    public static final Property meterOut = BMeter.newProperty((int)266, (BValue)new BStatusBoolean(false), null);
    public static final Property isRateLinked = BMeter.newProperty((int)259, (boolean)false, null);
    public static final Property rateIn = BMeter.newProperty((int)256, (BValue)new BStatusNumeric(0.0), (BFacets)BFacets.make((String)"precision", (BIDataValue)BDouble.make((double)5.0)));
    public static final Property historyCapacity = BMeter.newProperty((int)0, (BValue)BCapacity.UNLIMITED, null);
    public static final Property hid = BMeter.newProperty((int)68, (String)"", null);
    public static final Property MeterSummary = BMeter.newProperty((int)0, (BValue)new BPxView(BOrd.NULL), null);
    public static final Property MeterConfig = BMeter.newProperty((int)0, (BValue)new BPxView(BOrd.NULL), null);
    public static final Action poll = BMeter.newAction((int)2052, null);
    public static final Action update = BMeter.newAction((int)2052, null);
    public static final Type TYPE = Sys.loadType(BMeter.class);
    protected double baseCharges = 0.0;
    protected double baseConsumption = 0.0;
    protected double lastMeterReading = 0.0;

    public String getTitle() {
        return this.getString(title);
    }

    public void setTitle(String v) {
        this.setString(title, v, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    public boolean getWholeQuantities() {
        return this.getBoolean(wholeQuantities);
    }

    public void setWholeQuantities(boolean v) {
        this.setBoolean(wholeQuantities, v, null);
    }

    public String getUnitSymbol() {
        return this.getString(unitSymbol);
    }

    public void setUnitSymbol(String v) {
        this.setString(unitSymbol, v, null);
    }

    public boolean getActive() {
        return this.getBoolean(active);
    }

    public void setActive(boolean v) {
        this.setBoolean(active, v, null);
    }

    public BAbsTime getActivityBegan() {
        return (BAbsTime)this.get(activityBegan);
    }

    public void setActivityBegan(BAbsTime v) {
        this.set(activityBegan, (BValue)v, null);
    }

    public String getUser() {
        return this.getString(user);
    }

    public void setUser(String v) {
        this.setString(user, v, null);
    }

    public double getCurrentCharges() {
        return this.getDouble(currentCharges);
    }

    public void setCurrentCharges(double v) {
        this.setDouble(currentCharges, v, null);
    }

    public double getCurrentConsumption() {
        return this.getDouble(currentConsumption);
    }

    public void setCurrentConsumption(double v) {
        this.setDouble(currentConsumption, v, null);
    }

    public double getCurrentConsumptionMax() {
        return this.getDouble(currentConsumptionMax);
    }

    public void setCurrentConsumptionMax(double v) {
        this.setDouble(currentConsumptionMax, v, null);
    }

    public double getInvoiceConsumption() {
        return this.getDouble(invoiceConsumption);
    }

    public void setInvoiceConsumption(double v) {
        this.setDouble(invoiceConsumption, v, null);
    }

    public double getInvoiceConsumptionMax() {
        return this.getDouble(invoiceConsumptionMax);
    }

    public void setInvoiceConsumptionMax(double v) {
        this.setDouble(invoiceConsumptionMax, v, null);
    }

    public double getInvoiceCharges() {
        return this.getDouble(invoiceCharges);
    }

    public void setInvoiceCharges(double v) {
        this.setDouble(invoiceCharges, v, null);
    }

    public double getInvoiceSubtotal() {
        return this.getDouble(invoiceSubtotal);
    }

    public void setInvoiceSubtotal(double v) {
        this.setDouble(invoiceSubtotal, v, null);
    }

    public double getRate() {
        return this.getDouble(rate);
    }

    public void setRate(double v) {
        this.setDouble(rate, v, null);
    }

    public BStatusBoolean getMeterOut() {
        return (BStatusBoolean)this.get(meterOut);
    }

    public void setMeterOut(BStatusBoolean v) {
        this.set(meterOut, (BValue)v, null);
    }

    public boolean getIsRateLinked() {
        return this.getBoolean(isRateLinked);
    }

    public void setIsRateLinked(boolean v) {
        this.setBoolean(isRateLinked, v, null);
    }

    public BStatusNumeric getRateIn() {
        return (BStatusNumeric)this.get(rateIn);
    }

    public void setRateIn(BStatusNumeric v) {
        this.set(rateIn, (BValue)v, null);
    }

    public BCapacity getHistoryCapacity() {
        return (BCapacity)this.get(historyCapacity);
    }

    public void setHistoryCapacity(BCapacity v) {
        this.set(historyCapacity, (BValue)v, null);
    }

    public String getHid() {
        return this.getString(hid);
    }

    public void setHid(String v) {
        this.setString(hid, v, null);
    }

    public BPxView getMeterSummary() {
        return (BPxView)this.get(MeterSummary);
    }

    public void setMeterSummary(BPxView v) {
        this.set(MeterSummary, (BValue)v, null);
    }

    public BPxView getMeterConfig() {
        return (BPxView)this.get(MeterConfig);
    }

    public void setMeterConfig(BPxView v) {
        this.set(MeterConfig, (BValue)v, null);
    }

    @Override
    public void poll() {
        this.invoke(poll, null, null);
    }

    public void update() {
        this.invoke(update, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BMeter asMeter() {
        return this;
    }

    public void atSteadyState() {
        if (this.isSimpleDailyMeter()) {
            this.setActive(true);
            this.computeInvoiceStats();
        } else {
            this.update();
        }
    }

    public double calculateCost(BOverrideEvent event) {
        if (!this.getIsRateLinked()) {
            return this.cost(event.getStart(), event.getEnd(), this.getRateIn());
        }
        BComponent src = null;
        BLink[] links = this.getLinks((Slot)rateIn);
        int i = links.length;
        while (--i >= 0) {
            try {
                src = links[i].getSourceComponent();
                if (!(src instanceof BNumericSchedule)) continue;
                break;
            }
            catch (Exception exception) {
            }
        }
        if (!(src instanceof BNumericSchedule)) {
            return this.cost(event.getStart(), event.getEnd(), this.getRateIn());
        }
        BNumericSchedule schedule = (BNumericSchedule)src;
        BAbsTime start = event.getStart();
        BAbsTime end = event.getEnd();
        BAbsTime next = null;
        double cost = 0.0;
        while (start.isBefore(end)) {
            next = schedule.nextOutputSource(start, end);
            if (next == null) {
                next = end;
            } else if (next.isAfter(end)) {
                next = end;
            }
            cost += this.cost(start, next, (BStatusNumeric)schedule.getOutput(start));
            start = next;
        }
        return cost;
    }

    private double cost(BAbsTime s, BAbsTime e, BStatusNumeric rate) {
        if (!rate.getStatus().isValid()) {
            return 0.0;
        }
        double millis = e.getMillis() - s.getMillis();
        if (millis < 0.0) {
            return 0.0;
        }
        return millis / 3600000.0 * rate.getValue();
    }

    public void changed(Property p, Context cx) {
        if (this.isRunning()) {
            if (p == rateIn) {
                this.update();
            }
            if (p.getName().equals("meterIn") && this.getActive() != this.shouldBeActive()) {
                this.update();
            }
        }
        super.changed(p, cx);
    }

    public BHistoryId getHistoryId() {
        String hid = this.getHid();
        if (hid == "") {
            BHistoryId tmp = BHistoryId.make((String)this.getParent().getName(), (String)this.getName());
            hid = tmp.encodeToString();
            this.setHid(hid);
        }
        return (BHistoryId)BHistoryId.DEFAULT.decodeFromString(hid);
    }

    public double getInvoiceAmount(BAbsTime start, BAbsTime end) {
        double ret = 0.0;
        BInvoiceRecord[] ary = this.getInvoiceRecords(start, end);
        for (int i = 0; i < ary.length; ++i) {
            ret += ary[i].getCharges();
        }
        return ret;
    }

    public BInvoiceRecord[] getInvoiceRecords(BAbsTime start, BAbsTime end) {
        BIHistory history = null;
        try {
            BHistoryId id;
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = service.getDatabase();
            if (db == null) {
                return new BInvoiceRecord[0];
            }
            HistoryDatabaseConnection hConn = db.getDbConnection(null);
            if (!hConn.exists(id = this.getHistoryId())) {
                return new BInvoiceRecord[0];
            }
            history = hConn.getHistory(id);
            hConn.close();
        }
        catch (Exception x) {
            this.getOwner().getLog().error("History problem", (Throwable)x);
            return new BInvoiceRecord[0];
        }
        Vector<BInvoiceRecord> v = new Vector<BInvoiceRecord>();
        try {
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = service.getDatabase();
            HistoryDatabaseConnection hConn = db.getDbConnection(null);
            BITable results = hConn.timeQuery(history, start, end);
            TableCursor c = results.cursor();
            String myName = this.getTitle();
            BInvoiceRecord rec = null;
            while (c.next()) {
                rec = (BInvoiceRecord)((Object)c.get());
                rec = (BInvoiceRecord)rec.newCopy(true);
                rec.setMeter(myName);
                v.addElement(rec);
            }
        }
        catch (Exception x) {
            this.getOwner().getLog().error("History problem", (Throwable)x);
        }
        BInvoiceRecord[] ret = new BInvoiceRecord[v.size()];
        v.copyInto((Object[])ret);
        return ret;
    }

    public void doPoll() {
        if (this.getActive()) {
            double curQty = this.getCurrentQuantity();
            double curCon = this.getCurrentConsumption();
            if (curCon == 0.0 || curCon != curQty) {
                this.setCurrentConsumption(curQty);
                while (this.getCurrentConsumptionMax() < curCon) {
                    this.setCurrentConsumptionMax(this.getCurrentConsumptionMax() * 2.0);
                }
                this.setCurrentCharges(curCon * this.getRate());
                this.setInvoiceConsumption(this.baseConsumption + curCon);
                while (this.getInvoiceConsumptionMax() < this.getInvoiceConsumption()) {
                    this.setInvoiceConsumptionMax(this.getInvoiceConsumptionMax() * 2.0);
                }
                this.setInvoiceCharges(this.baseCharges + this.getCurrentCharges());
            }
            if (Clock.time().getDay() != this.getActivityBegan().getDay()) {
                this.update();
            }
        } else if (this.getCurrentCharges() != 0.0) {
            while (this.getCurrentConsumptionMax() < this.getCurrentConsumption()) {
                this.setCurrentConsumptionMax(this.getCurrentConsumptionMax() * 2.0);
            }
            while (this.getInvoiceConsumptionMax() < this.getInvoiceConsumption()) {
                this.setInvoiceConsumptionMax(this.getInvoiceConsumptionMax() * 2.0);
            }
            this.setInvoiceConsumption(this.baseConsumption);
            this.setInvoiceCharges(this.baseCharges);
            this.setCurrentConsumption(0.0);
            this.setCurrentCharges(0.0);
        }
    }

    public synchronized void doUpdate() {
        this.setIsRateLinked(this.isLinkTarget((Slot)rateIn));
        if (!Sys.atSteadyState()) {
            return;
        }
        BAbsTime now = Clock.time();
        int hour = now.getHour();
        int minute = now.getMinute();
        if (this.isSimpleDailyMeter()) {
            hour = 0;
            minute = 0;
        } else if (hour == 0 && minute < 5) {
            minute = 0;
        } else if (minute % 5 != 0 && now.getSecond() > 30) {
            ++minute;
        }
        now = BAbsTime.make((int)now.getYear(), (BMonth)now.getMonth(), (int)now.getDay(), (int)hour, (int)minute, (int)0, (int)0);
        if (this.getActive() && (this.getRate() != 0.0 || this.getLogNoCostEvents()) && now.isAfter(this.getActivityBegan())) {
            BInvoiceRecord rec = new BInvoiceRecord();
            rec.setStart(this.getActivityBegan());
            rec.setEnd(now);
            rec.setRate(this.getRate());
            rec.setQuantity(this.getCurrentQuantity());
            rec.setUser(this.getUser());
            this.addRecord(rec);
        }
        if (this.shouldBeActive()) {
            this.setActive(true);
            this.setMeterOut(new BStatusBoolean(true));
            if (!now.equivalent((Object)this.getActivityBegan())) {
                this.setActivityBegan(now);
                this.setMeterStart();
            }
        } else {
            this.setActive(false);
            this.setMeterOut(new BStatusBoolean(false));
        }
        this.computeInvoiceStats();
    }

    public boolean getLogNoCostEvents() {
        return false;
    }

    @Override
    public BPollFrequency getPollFrequency() {
        return BPollFrequency.fast;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BSuite;
    }

    @Override
    public void started() throws Exception {
        if (Sys.atSteadyState() && this.getHid().equals("")) {
            this.makeNewId();
        }
        super.started();
    }

    @Override
    public void stopped() throws Exception {
        if (!this.isSimpleDailyMeter()) {
            this.doUpdate();
        }
        super.stopped();
    }

    protected abstract double getCurrentQuantity();

    protected abstract boolean isMeterActive();

    protected abstract void setMeterStart();

    protected void addRecord(BInvoiceRecord record) {
        double amt = record.getCharges();
        if (amt == 0.0 && !this.getLogNoCostEvents()) {
            return;
        }
        if (Double.isNaN(amt) || Double.isInfinite(amt)) {
            return;
        }
        long start = record.getStart().getMillis();
        long end = record.getTimestamp().getMillis();
        if (end - start < 60000L) {
            return;
        }
        try {
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = service.getDatabase();
            if (db == null) {
                this.getOwner().handleError(this.getTenant(), "Could not find history database", new Exception());
                return;
            }
            HistoryDatabaseConnection hConn = db.getDbConnection(null);
            BHistoryId id = this.getHistoryId();
            BHistoryConfig config = new BHistoryConfig(id, BTypeSpec.make((Type)BInvoiceRecord.TYPE));
            config.setSource(BOrdList.make((BOrd)this.getSlotPathOrd()));
            config.setTimeZone(Clock.time().getTimeZone());
            config.setCapacity(this.getHistoryCapacity());
            if (hConn.exists(id)) {
                hConn.reconfigureHistory(config);
            } else {
                id = this.makeNewId();
                config = new BHistoryConfig(id, BTypeSpec.make((Type)BInvoiceRecord.TYPE));
                config.setSource(BOrdList.make((BOrd)this.getSlotPathOrd()));
                config.setTimeZone(Clock.time().getTimeZone());
                if (!hConn.exists(id)) {
                    hConn.createHistory(config);
                } else {
                    hConn.reconfigureHistory(config);
                }
            }
            BIHistory history = hConn.getHistory(id);
            BAbsTime lastEnd = hConn.getLastTimestamp(history);
            if (!record.getStart().isBefore(lastEnd)) {
                hConn.append(history, (BIHistoryRecordSet)record);
                hConn.flush(history);
            }
        }
        catch (Exception e) {
            this.getOwner().handleError(this.getTenant(), "History problem", e);
        }
    }

    protected void computeInvoiceStats() {
        double consumption = 0.0;
        double subtotal = 0.0;
        BAbsTime start = this.getTenant().getLastInvoice().toAbsTime();
        BAbsTime end = this.getTenant().getNextInvoice().toAbsTime();
        BInvoiceRecord[] ary = this.getInvoiceRecords(start, end);
        for (int i = 0; i < ary.length; ++i) {
            subtotal += ary[i].getCharges();
            consumption += ary[i].getQuantity();
        }
        this.baseConsumption = consumption;
        this.baseCharges = subtotal;
        if (!this.getActive()) {
            this.setInvoiceConsumption(this.baseConsumption);
            this.setInvoiceCharges(this.baseCharges);
        }
    }

    protected boolean isSimpleDailyMeter() {
        return false;
    }

    protected static BNumericSchedule makeRateSchedule() {
        BNumericSchedule ret = new BNumericSchedule();
        ret.setDefaultOutput((BStatusValue)new BStatusNumeric(0.0, BStatus.ok));
        ret.setFacets(BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)5)));
        ret.setCleanupExpiredEvents(true);
        ret.add("RateConfig", (BValue)new BPxView(BOrd.make((String)"module://kodarotenant/px/RateConfig.px")), 256);
        return ret;
    }

    protected double quantity(double val) {
        if (this.getWholeQuantities()) {
            double diff = val % 1.0;
            val = diff > 0.005 ? val - diff + 1.0 : (val -= diff);
        }
        return val;
    }

    synchronized void clearOldHistory(BAbsTime before, Context cx) {
        try {
            BHistoryId id;
            HistoryDatabaseConnection hConn;
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = service.getDatabase();
            if (db != null && (hConn = db.getDbConnection(null)).exists(id = this.getHistoryId())) {
                if (before == null) {
                    hConn.deleteHistory(id);
                } else {
                    BIHistory history = hConn.getHistory(id);
                    if (hConn.getRecordCount(history) == 0) {
                        return;
                    }
                    BAbsTime first = hConn.getFirstTimestamp(history);
                    if (first.isNull()) {
                        return;
                    }
                    if (first.isBefore(before)) {
                        hConn.clearOldRecords(id, before);
                    }
                }
            }
        }
        catch (Exception x) {
            this.getOwner().getLog().warning("Clearing history of " + this.toPathString(), (Throwable)x);
        }
    }

    private BHistoryId makeNewId() {
        String device = this.getOwner().getDisplayName(null);
        device = this.scrubName(device);
        device = SlotPath.escape((String)device);
        String history = this.getTenant().getDisplayName(null);
        history = history + "_" + this.getDisplayName(null);
        history = history + "_" + this.getHandle().toString();
        history = this.scrubName(history);
        history = SlotPath.escape((String)history);
        BHistoryId ret = BHistoryId.make((String)device, (String)history);
        this.setHid(ret.encodeToString());
        return ret;
    }

    private String scrubName(String s) {
        StringBuffer buf = new StringBuffer(s);
        int j = buf.length();
        while (--j >= 0) {
            char ch = buf.charAt(j);
            if (Character.isLetterOrDigit(ch)) continue;
            if (ch == '#') {
                buf.deleteCharAt(j);
                continue;
            }
            buf.setCharAt(j, '_');
        }
        s = buf.toString();
        while (s.indexOf("__") >= 0) {
            s = TextUtil.replace((String)s, (String)"__", (String)"_");
        }
        if (s.length() > 44) {
            s = TextUtil.replace((String)s, (String)"_", (String)"");
        }
        if (s.length() > 44) {
            int len = s.length();
            s = s.substring(len - 44);
        }
        return s;
    }

    private boolean shouldBeActive() {
        BStatusNumeric in = this.getRateIn();
        if (in.getStatus().isNull()) {
            this.setRate(0.0);
            return false;
        }
        if (in.getValue() == 0.0 && !this.getLogNoCostEvents()) {
            this.setRate(0.0);
            return false;
        }
        this.setRate(in.getValue());
        return this.isMeterActive();
    }
}

