/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant;

import com.kodaro.tenant.BMeter;
import javax.baja.agent.BPxView;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BNumericMeter
extends BMeter {
    public static final Property meterIn = BNumericMeter.newProperty((int)266, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"precision", (BIDataValue)BDouble.make((double)2.0)));
    public static final Property meterStart = BNumericMeter.newProperty((int)257, (double)0.0, (BFacets)BFacets.make((String)"precision", (BIDataValue)BDouble.make((double)2.0)));
    public static final Property maxValue = BNumericMeter.newProperty((int)256, (double)0.0, (BFacets)BFacets.make((String)"precision", (BIDataValue)BDouble.make((double)2.0)));
    public static final Property minValue = BNumericMeter.newProperty((int)256, (double)0.0, (BFacets)BFacets.make((String)"precision", (BIDataValue)BDouble.make((double)2.0)));
    public static final Property description = BNumericMeter.newProperty((int)257, (String)"Numeric Meter", null);
    public static final Property unitSymbol = BNumericMeter.newProperty((int)256, (String)"kWH", null);
    public static final Property simpleDailyMeter = BNumericMeter.newProperty((int)256, (boolean)false, null);
    public static final Property MeterSummary = BNumericMeter.newProperty((int)0, (BValue)new BPxView(BOrd.make((String)"module://kodarotenant/px/NumericMeterSummary.px")), null);
    public static final Property MeterConfig = BNumericMeter.newProperty((int)0, (BValue)new BPxView(BOrd.make((String)"module://kodarotenant/px/NumericMeterConfig.px")), null);
    public static final Action update = BNumericMeter.newAction((int)276, null);
    public static final Type TYPE = Sys.loadType(BNumericMeter.class);
    public static BIcon icon = BIcon.make((String)"module://kodarotenant/img/dial.png");

    public BStatusNumeric getMeterIn() {
        return (BStatusNumeric)this.get(meterIn);
    }

    public void setMeterIn(BStatusNumeric v) {
        this.set(meterIn, (BValue)v, null);
    }

    public double getMeterStart() {
        return this.getDouble(meterStart);
    }

    public void setMeterStart(double v) {
        this.setDouble(meterStart, v, null);
    }

    public double getMaxValue() {
        return this.getDouble(maxValue);
    }

    public void setMaxValue(double v) {
        this.setDouble(maxValue, v, null);
    }

    public double getMinValue() {
        return this.getDouble(minValue);
    }

    public void setMinValue(double v) {
        this.setDouble(minValue, v, null);
    }

    @Override
    public String getDescription() {
        return this.getString(description);
    }

    @Override
    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    @Override
    public String getUnitSymbol() {
        return this.getString(unitSymbol);
    }

    @Override
    public void setUnitSymbol(String v) {
        this.setString(unitSymbol, v, null);
    }

    public boolean getSimpleDailyMeter() {
        return this.getBoolean(simpleDailyMeter);
    }

    public void setSimpleDailyMeter(boolean v) {
        this.setBoolean(simpleDailyMeter, v, null);
    }

    @Override
    public BPxView getMeterSummary() {
        return (BPxView)this.get(MeterSummary);
    }

    @Override
    public void setMeterSummary(BPxView v) {
        this.set(MeterSummary, (BValue)v, null);
    }

    @Override
    public BPxView getMeterConfig() {
        return (BPxView)this.get(MeterConfig);
    }

    @Override
    public void setMeterConfig(BPxView v) {
        this.set(MeterConfig, (BValue)v, null);
    }

    @Override
    public void update() {
        this.invoke(update, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    @Override
    protected double getCurrentQuantity() {
        double meterStart = this.getMeterStart();
        if (meterStart == 0.0) {
            this.setMeterStart();
            meterStart = this.getMeterStart();
        }
        if (meterStart == 0.0) {
            return this.getCurrentConsumption();
        }
        BStatusNumeric val = this.getMeterIn();
        if (!val.getStatus().isValid()) {
            return this.getCurrentConsumption();
        }
        double meterNow = val.getValue();
        if (Double.isNaN(meterNow)) {
            return this.getCurrentConsumption();
        }
        if (meterNow < meterStart) {
            if (meterNow == 0.0) {
                return this.getCurrentConsumption();
            }
            if (this.getMaxValue() > 0.0) {
                double qty = this.getMaxValue() - meterStart;
                return this.quantity(qty += meterNow - this.getMinValue());
            }
            return this.getCurrentConsumption();
        }
        return this.quantity(meterNow - meterStart);
    }

    @Override
    protected boolean isMeterActive() {
        return this.getMeterIn().getStatus().isValid();
    }

    @Override
    protected boolean isSimpleDailyMeter() {
        return this.getSimpleDailyMeter();
    }

    @Override
    protected void setMeterStart() {
        BStatusNumeric val = this.getMeterIn();
        double v = val.getValue();
        if (val.getStatus().isValid() && !Double.isNaN(v)) {
            this.setMeterStart(v);
            return;
        }
        this.setMeterStart(0.0);
    }
}

