/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant;

import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BOverrideEvent
extends BDailySchedule {
    public static final Property start = BOverrideEvent.newProperty((int)0x10000000, (BValue)BAbsTime.NULL, null);
    public static final Property end = BOverrideEvent.newProperty((int)0x10000000, (BValue)BAbsTime.NULL, null);
    public static final Property user = BOverrideEvent.newProperty((int)0, (String)"", null);
    public static final Property effectiveValue = BOverrideEvent.newProperty((int)0, (BValue)new BStatusBoolean(true), null);
    public static final Type TYPE = Sys.loadType(BOverrideEvent.class);

    public BAbsTime getStart() {
        return (BAbsTime)this.get(start);
    }

    public void setStart(BAbsTime v) {
        this.set(start, (BValue)v, null);
    }

    public BAbsTime getEnd() {
        return (BAbsTime)this.get(end);
    }

    public void setEnd(BAbsTime v) {
        this.set(end, (BValue)v, null);
    }

    public String getUser() {
        return this.getString(user);
    }

    public void setUser(String v) {
        this.setString(user, v, null);
    }

    public BStatusValue getEffectiveValue() {
        return (BStatusValue)this.get(effectiveValue);
    }

    public void setEffectiveValue(BStatusValue v) {
        this.set(effectiveValue, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String duration() {
        long val = this.getEnd().getMillis() - this.getStart().getMillis();
        if (val <= 0L) {
            return "00:00";
        }
        int hours = (int)(val / 3600000L);
        int mins = (int)((val %= 3600000L) / 60000L);
        StringBuffer buf = new StringBuffer();
        if (hours < 10) {
            buf.append('0');
        }
        buf.append(hours);
        buf.append(':');
        if (mins < 10) {
            buf.append('0');
        }
        buf.append(mins);
        return buf.toString();
    }

    public Integer durationInHours() {
        long val = this.getEnd().getMillis() - this.getStart().getMillis();
        if (val <= 0L) {
            return new Integer(0);
        }
        int ret = (int)(val / 3600000L);
        if (val % 3600000L > 0L) {
            ++ret;
        }
        return new Integer(ret);
    }

    public BAbstractSchedule getDays() {
        if (this.getEnd().isBefore(Clock.time()) && this.isRunning() && Sys.atSteadyState()) {
            this.getParent().asComponent().remove((BComplex)this);
        }
        return this;
    }

    public boolean isEffective(BAbsTime arg) {
        if (this.getAlwaysEffective()) {
            return true;
        }
        BAbsTime start = this.getStart();
        BAbsTime end = this.getEnd();
        if (arg.equals((Object)start) || arg.isAfter(start)) {
            return arg.isBefore(this.getEnd());
        }
        return false;
    }

    public BAbsTime nextEvent(BAbsTime arg) {
        if (arg.isBefore(this.getStart())) {
            return this.getStart();
        }
        if (arg.isBefore(this.getEnd())) {
            return this.getEnd();
        }
        return null;
    }

    public String toString(Context cx) {
        return this.getStart() + " - " + this.getEnd();
    }
}

