/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant;

import com.kodaro.tenant.BBooleanMeter;
import com.kodaro.tenant.BOverrideEvent;
import com.kodaro.tenant.IScheduledMeter;
import com.kodaro.tenant.util.BHours;
import java.util.Vector;
import javax.baja.agent.BPxView;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

public class BScheduledBooleanMeter
extends BBooleanMeter
implements IScheduledMeter {
    public static final Property description = BScheduledBooleanMeter.newProperty((int)257, (String)"Boolean Meter with Override Schedule", null);
    public static final Property activityEnds = BScheduledBooleanMeter.newProperty((int)259, (BValue)BAbsTime.NULL, null);
    public static final Property activityDuration = BScheduledBooleanMeter.newProperty((int)259, (BValue)BRelTime.DEFAULT, null);
    public static final Property hasNext = BScheduledBooleanMeter.newProperty((int)259, (boolean)false, null);
    public static final Property nextUser = BScheduledBooleanMeter.newProperty((int)259, (String)"", null);
    public static final Property nextStart = BScheduledBooleanMeter.newProperty((int)259, (BValue)BAbsTime.NULL, null);
    public static final Property nextEnd = BScheduledBooleanMeter.newProperty((int)259, (BValue)BAbsTime.NULL, null);
    public static final Property nextDuration = BScheduledBooleanMeter.newProperty((int)259, (BValue)BRelTime.DEFAULT, null);
    public static final Property overrideSchedule = BScheduledBooleanMeter.newProperty((int)256, (BValue)BScheduledBooleanMeter.makeOverrideSchedule(), null);
    public static final Property overrideIn = BScheduledBooleanMeter.newProperty((int)7, (BValue)new BStatusBoolean(false), null);
    public static final Property MeterSummary = BScheduledBooleanMeter.newProperty((int)0, (BValue)new BPxView(BOrd.make((String)"module://kodarotenant/px/ScheduledBooleanMeterSummary.px")), null);
    public static final Property FutureEventList = BScheduledBooleanMeter.newProperty((int)0, (BValue)new BPxView(BOrd.make((String)"module://kodarotenant/px/FutureEvents.px")), null);
    public static final Action cancelCurrentOverride = BScheduledBooleanMeter.newAction((int)272, null);
    public static final Action cancelOverride = BScheduledBooleanMeter.newAction((int)276, (BValue)BString.DEFAULT, null);
    public static final Action checkSchedule = BScheduledBooleanMeter.newAction((int)276, null);
    public static final Action override = BScheduledBooleanMeter.newAction((int)272, (BValue)new BOverrideEvent(), null);
    public static final Action overrideNow = BScheduledBooleanMeter.newAction((int)272, (BValue)BHours.DEFAULT, null);
    public static final Action update = BScheduledBooleanMeter.newAction((int)276, null);
    public static final Type TYPE = Sys.loadType(BScheduledBooleanMeter.class);
    private BAbstractSchedule last = null;

    @Override
    public String getDescription() {
        return this.getString(description);
    }

    @Override
    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    public BAbsTime getActivityEnds() {
        return (BAbsTime)this.get(activityEnds);
    }

    public void setActivityEnds(BAbsTime v) {
        this.set(activityEnds, (BValue)v, null);
    }

    public BRelTime getActivityDuration() {
        return (BRelTime)this.get(activityDuration);
    }

    public void setActivityDuration(BRelTime v) {
        this.set(activityDuration, (BValue)v, null);
    }

    public boolean getHasNext() {
        return this.getBoolean(hasNext);
    }

    public void setHasNext(boolean v) {
        this.setBoolean(hasNext, v, null);
    }

    public String getNextUser() {
        return this.getString(nextUser);
    }

    public void setNextUser(String v) {
        this.setString(nextUser, v, null);
    }

    public BAbsTime getNextStart() {
        return (BAbsTime)this.get(nextStart);
    }

    public void setNextStart(BAbsTime v) {
        this.set(nextStart, (BValue)v, null);
    }

    public BAbsTime getNextEnd() {
        return (BAbsTime)this.get(nextEnd);
    }

    public void setNextEnd(BAbsTime v) {
        this.set(nextEnd, (BValue)v, null);
    }

    public BRelTime getNextDuration() {
        return (BRelTime)this.get(nextDuration);
    }

    public void setNextDuration(BRelTime v) {
        this.set(nextDuration, (BValue)v, null);
    }

    @Override
    public BBooleanSchedule getOverrideSchedule() {
        return (BBooleanSchedule)this.get(overrideSchedule);
    }

    public void setOverrideSchedule(BBooleanSchedule v) {
        this.set(overrideSchedule, (BValue)v, null);
    }

    public BStatusBoolean getOverrideIn() {
        return (BStatusBoolean)this.get(overrideIn);
    }

    public void setOverrideIn(BStatusBoolean v) {
        this.set(overrideIn, (BValue)v, null);
    }

    @Override
    public BPxView getMeterSummary() {
        return (BPxView)this.get(MeterSummary);
    }

    @Override
    public void setMeterSummary(BPxView v) {
        this.set(MeterSummary, (BValue)v, null);
    }

    @Override
    public BPxView getFutureEventList() {
        return (BPxView)this.get(FutureEventList);
    }

    public void setFutureEventList(BPxView v) {
        this.set(FutureEventList, (BValue)v, null);
    }

    @Override
    public void cancelCurrentOverride() {
        this.invoke(cancelCurrentOverride, null, null);
    }

    @Override
    public void cancelOverride(BString arg) {
        this.invoke(cancelOverride, (BValue)arg, null);
    }

    public void checkSchedule() {
        this.invoke(checkSchedule, null, null);
    }

    public void override(BOverrideEvent arg) {
        this.invoke(override, (BValue)arg, null);
    }

    public void overrideNow(BHours arg) {
        this.invoke(overrideNow, (BValue)arg, null);
    }

    @Override
    public void update() {
        this.invoke(update, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void changed(Property p, Context cx) {
        if (this.isRunning() && p == overrideIn) {
            this.update();
        }
        super.changed(p, cx);
    }

    public void doCancelOverride(BString name) {
        String str = name.getString();
        str = SlotPath.escape((String)str);
        this.sch().getSpecialEvents().remove(str);
    }

    public void doCancelCurrentOverride() {
        BOverrideEvent e = this.getCurrentOverride();
        while (e != null) {
            e.setEnd(this.make(Clock.time()));
            this.sch().execute();
            e = this.getCurrentOverride();
        }
    }

    public void doCheckSchedule() {
        BAbstractSchedule o = this.sch().getOutputSource(Clock.time());
        if (o != this.last) {
            this.update();
        } else {
            BAbsTime next = o.nextEvent(Clock.time().add(BRelTime.make((long)5000L)));
            if (next != null && !next.isNull()) {
                Clock.schedule((BComponent)this, (BAbsTime)next.add(BRelTime.make((long)5000L)), (Action)checkSchedule, null);
            }
        }
    }

    @Override
    public void doOverride(BOverrideEvent event, Context cx) {
        if (event.getStart().isNull()) {
            return;
        }
        event.setStart(this.make(event.getStart()));
        event.setEnd(this.make(event.getEnd()));
        String name = event.getUser();
        if (name.equals("")) {
            name = cx.getUser().getName();
            event.setUser(cx.getUser().getUsername());
        }
        name = SlotPath.escape((String)name);
        this.sch().addSpecialEvent(name + "?", (BDailySchedule)event);
        this.getOwner().handleOverride(this.getTenant(), event, cx);
    }

    @Override
    public void doPoll() {
        BOverrideEvent[] future = this.getFutureEvents();
        if (future != null && future.length > 0) {
            BOverrideEvent e = future[0];
            this.setHasNext(true);
            this.setNextUser(e.getUser());
            this.setNextStart(e.getStart());
            this.setNextEnd(e.getEnd());
            this.setNextDuration(e.getStart().delta(e.getEnd()));
        } else {
            this.setHasNext(false);
        }
        super.doPoll();
    }

    @Override
    public void doOverrideNow(BHours hours, Context cx) {
        if (hours.getHours() == 0) {
            return;
        }
        BOverrideEvent e = new BOverrideEvent();
        BAbsTime now = this.make(Clock.time());
        e.setStart(now);
        e.setEnd(this.make(now.add(BRelTime.make((long)hours.getMillis()))));
        e.setUser(cx.getUser().getUsername());
        this.sch().addSpecialEvent(cx.getUser().getName() + "?", (BDailySchedule)e);
        this.getOwner().handleOverride(this.getTenant(), e, cx);
    }

    public BValue getActionParameterDefault(Action a) {
        if (a == override) {
            BAbsTime now = Clock.time().add(BRelTime.HOUR);
            BAbsTime start = BAbsTime.make((int)now.getYear(), (BMonth)now.getMonth(), (int)now.getDay(), (int)now.getHour(), (int)0);
            BAbsTime end = start.add(BRelTime.HOUR);
            BOverrideEvent ret = new BOverrideEvent();
            ret.setStart(start);
            ret.setEnd(end);
            return ret;
        }
        return super.getActionParameterDefault(a);
    }

    public BOverrideEvent getCurrentOverride() {
        BAbstractSchedule o = this.sch().getOutputSource(Clock.time());
        if (o instanceof BOverrideEvent) {
            return (BOverrideEvent)o;
        }
        return null;
    }

    public BOverrideEvent[] getEvents(BMonth month, int year) {
        BOverrideEvent[] kids = (BOverrideEvent[])this.sch().getSpecialEvents().getChildren(BOverrideEvent.class);
        int len = kids.length;
        Vector<BOverrideEvent> v = new Vector<BOverrideEvent>(len);
        BAbsTime da = Clock.time();
        for (int i = 0; i < len; ++i) {
            if (kids[i].getEnd().getYear() != year || kids[i].getEnd().getMonth() != month) continue;
            v.addElement(kids[i]);
        }
        len = v.size();
        kids = new BOverrideEvent[len];
        v.copyInto((Object[])kids);
        this.sort(kids);
        return kids;
    }

    @Override
    public BOverrideEvent[] getFutureEvents() {
        BOverrideEvent[] kids = (BOverrideEvent[])this.sch().getSpecialEvents().getChildren(BOverrideEvent.class);
        int len = kids.length;
        Vector<BOverrideEvent> v = new Vector<BOverrideEvent>(len);
        BAbsTime now = Clock.time();
        for (int i = 0; i < len; ++i) {
            if (!kids[i].getEnd().isAfter(now)) continue;
            v.addElement(kids[i]);
        }
        len = v.size();
        kids = new BOverrideEvent[len];
        v.copyInto((Object[])kids);
        this.sort(kids);
        return kids;
    }

    @Override
    public BOverrideEvent getOverride(String name) {
        name = SlotPath.escape((String)name);
        return (BOverrideEvent)this.sch().getSpecialEvents().get(name);
    }

    @Override
    public boolean getLogNoCostEvents() {
        return true;
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (!this.isLinkTarget((Slot)overrideIn)) {
            this.linkTo((BComponent)this.getOverrideSchedule(), (Slot)BBooleanSchedule.out, (Slot)overrideIn);
        }
    }

    @Override
    protected boolean isMeterActive() {
        if (!this.getOverrideIn().getBoolean()) {
            return false;
        }
        return super.isMeterActive();
    }

    @Override
    protected void setMeterStart() {
        BAbstractSchedule o;
        this.last = o = this.sch().getOutputSource(Clock.time());
        if (o instanceof BOverrideEvent) {
            BOverrideEvent e = (BOverrideEvent)o;
            this.setUser(e.getUser());
        } else {
            this.setUser(this.sch().getOutSource());
        }
        BAbsTime next = this.sch().nextEvent(Clock.time().add(BRelTime.make((long)5000L)));
        if (next != null && !next.isNull()) {
            Clock.schedule((BComponent)this, (BAbsTime)next.add(BRelTime.make((long)5000L)), (Action)checkSchedule, null);
        }
        super.setMeterStart();
    }

    private BAbsTime make(BAbsTime t) {
        return BAbsTime.make((long)t.getMillis(), (BTimeZone)BTimeZone.getLocal());
    }

    private static BBooleanSchedule makeOverrideSchedule() {
        BBooleanSchedule ret = new BBooleanSchedule();
        ret.setDefaultOutput((BStatusValue)new BStatusBoolean(false, BStatus.ok));
        ret.setCleanupExpiredEvents(true);
        return ret;
    }

    private BBooleanSchedule sch() {
        return this.getOverrideSchedule();
    }

    private void sort(BOverrideEvent[] ary) {
        if (ary == null || ary.length == 0) {
            return;
        }
        int i = ary.length;
        while (--i >= 0) {
            int j = i;
            while (--j >= 0) {
                if (!ary[i].getStart().isBefore(ary[j].getStart())) continue;
                BOverrideEvent tmp = ary[i];
                ary[i] = ary[j];
                ary[j] = tmp;
            }
        }
    }
}

