/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant;

import com.kodaro.tenant.BSuite;
import com.kodaro.tenant.IScheduledMeter;
import com.kodaro.tenant.util.BHours;
import java.io.PrintWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.web.BWebServlet;
import javax.baja.web.WebOp;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BSmartPhoneInterface
extends BWebServlet {
    public static final Property servletName = BSmartPhoneInterface.newProperty((int)1, (String)"tenant", null);
    public static final Property selectAllByDefault = BSmartPhoneInterface.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BSmartPhoneInterface.class);
    private static BIcon icon = BIcon.std((String)"web.png");

    public boolean getSelectAllByDefault() {
        return this.getBoolean(selectAllByDefault);
    }

    public void setSelectAllByDefault(boolean v) {
        this.setBoolean(selectAllByDefault, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doGet(WebOp op) throws Exception {
        int i;
        HttpServletRequest req = op.getRequest();
        HttpServletResponse res = op.getResponse();
        BUser user = op.getUser();
        BOrd ord = user.getHomePage();
        OrdTarget targ = ord.resolve((BObject)this);
        BComponent comp = targ.getComponent();
        if (!(comp instanceof BSuite)) {
            op.getResponse().sendError(403, "Tenant access only.");
            return;
        }
        BSuite suite = (BSuite)comp;
        res.setContentType("text/html");
        PrintWriter w = res.getWriter();
        w.println("<html><body bgcolor=\"#d3e2e9\"><center>");
        w.println("<table border=\"0\" cellspacing=\"0\" cellpadding=\"5\">");
        w.println("<tr><td bgcolor=\"#8bc588\"><center><b>");
        w.println(suite.getAccount());
        w.println("</center></b></td></tr>");
        if (!suite.getHasScheduledMeters()) {
            w.print("<tr><td bgcolor=\"#85adc7\">Nothing to override.");
            w.println("</td></tr></table></center></body></html>");
            return;
        }
        w.println("<tr><td bgcolor=\"#85adc7\"><form method=\"post\">");
        IScheduledMeter[] ary = (IScheduledMeter[])suite.getChildren(IScheduledMeter.class);
        w.println("<i>Select Overrides</i><br>");
        for (i = 0; i < ary.length; ++i) {
            w.print(" <input type=\"checkbox\" name=\"meter\"");
            if (this.getSelectAllByDefault()) {
                w.print(" checked");
            }
            w.print(" value=\"");
            w.print(ary[i].asMeter().getName());
            w.print("\"/> ");
            w.print(ary[i].asMeter().getTitle());
            w.println("<br>");
        }
        w.println("<p><i>Duration In Hours</i><br>");
        w.println(" <input type=\"radio\" name=\"duration\" value=\"1\"/> 1");
        w.println(" <input type=\"radio\" name=\"duration\" checked value=\"2\"/> 2");
        w.println(" <input type=\"radio\" name=\"duration\" value=\"4\"/> 4");
        w.println(" <input type=\"radio\" name=\"duration\" value=\"6\"/> 6");
        w.print("<br>");
        i = 55;
        while (--i >= 0) {
            w.print("&nbsp;");
        }
        w.println("<br><center>");
        w.println("<input type=\"submit\" style=\"background: #e7ebf6; color: #212926; border: 0; padding: .2em;\" tabindex=1 value=\"Submit\"/>");
        w.println("</center></form></td></tr></table></center></body></html>");
    }

    public void doPost(WebOp op) throws Exception {
        HttpServletRequest req = op.getRequest();
        HttpServletResponse res = op.getResponse();
        BUser user = op.getUser();
        BOrd ord = user.getHomePage();
        OrdTarget targ = ord.resolve((BObject)this);
        BComponent comp = targ.getComponent();
        if (!(comp instanceof BSuite)) {
            op.getResponse().sendError(403, "Tenant access only.");
            return;
        }
        BSuite suite = (BSuite)comp;
        res.setContentType("text/html");
        PrintWriter w = res.getWriter();
        w.println("<html><body bgcolor=\"#d3e2e9\"><center>");
        w.println("<table border=\"0\" cellspacing=\"0\" cellpadding=\"5\">");
        w.print("<tr><td bgcolor=\"#8bc588\"><center><b>");
        w.print(suite.getAccount());
        w.println("</center></b></td></tr>");
        String dur = req.getParameter("duration");
        if (dur == null || dur.equals("")) {
            w.print("<tr><td bgcolor=\"#85adc7\">No duration was choosen.");
            w.println("</td></tr></table></center></body></html>");
            return;
        }
        String[] names = req.getParameterValues("meter");
        if (names == null || names.length == 0) {
            w.print("<tr><td bgcolor=\"#85adc7\">No overrides were selected.");
            w.println("</td></tr></table></center></body></html>");
            return;
        }
        w.println("<tr><td bgcolor=\"#85adc7\"><form method=\"get\">");
        w.println("<i>Successfully Overrode</i><br>");
        BHours hours = BHours.make(dur);
        int i = names.length;
        while (--i >= 0) {
            IScheduledMeter m = (IScheduledMeter)suite.get(names[i]);
            m.doOverrideNow(hours, (Context)op);
            w.print(" &#149; ");
            w.print(m.asMeter().getTitle());
            w.println("<br>");
        }
        w.println("<br><i>Override Duration</i><br>");
        w.print(" &#149; ");
        if (hours.getHours() == 1) {
            w.println("1 Hour");
        } else {
            w.println(dur + " Hours");
        }
        w.print("<br>");
        i = 55;
        while (--i >= 0) {
            w.print("&nbsp;");
        }
        w.println("<br><center>");
        w.print("<input type=\"submit\" style=\"background: #e7ebf6; color: #212926; border: 0; padding: .2em;\" value=\"Continue\"/>");
        w.println("</center>");
        w.println("</form></td></tr></table></center></body></html>");
    }

    public BIcon getIcon() {
        return icon;
    }

    public void service(WebOp op) throws Exception {
        if (!this.getEnabled()) {
            op.getResponse().sendError(410, "Disabled");
            return;
        }
        super.service(op);
    }

    private String replace(String src, String tok, String neu) {
        if (src == null) {
            return null;
        }
        int to = src.indexOf(tok);
        if (to < 0) {
            return src;
        }
        StringBuffer buf = new StringBuffer();
        int from = 0;
        int toklen = tok.length();
        while (to >= 0) {
            buf.append(src.substring(from, to));
            buf.append(neu);
            from = to + toklen;
            to = src.indexOf(tok, from);
        }
        if (from < src.length()) {
            buf.append(src.substring(from));
        }
        return buf.toString();
    }
}

