/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant;

import com.kodaro.tenant.BOverrideEvent;
import com.kodaro.tenant.BSuite;
import com.kodaro.tenant.BTbsLicense;
import com.kodaro.tenant.BTbsUser;
import com.kodaro.tenant.UserMgmt;
import com.kodaro.tenant.util.BTbsPollScheduler;
import com.kodaro.tenant.util.BTbsThreadPool;
import com.tridium.util.ThrowableUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.baja.agent.BPxView;
import javax.baja.category.BCategoryService;
import javax.baja.email.BEmail;
import javax.baja.email.BEmailAddress;
import javax.baja.email.BEmailAddressList;
import javax.baja.email.BEmailService;
import javax.baja.gx.BImage;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.role.BRole;
import javax.baja.role.BRoleService;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.security.BPermissions;
import javax.baja.security.BPermissionsMap;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.user.BUserService;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public final class BTenantBilling
extends BComponent
implements BIService {
    public static final String PX = "module://kodarotenant/px/";
    public static final Property useMasterRateSchedule = BTenantBilling.newProperty((int)256, (boolean)false, null);
    public static final Property masterRateSchedule = BTenantBilling.newProperty((int)256, (BValue)BTenantBilling.makeMasterSchedule(), null);
    public static final Property hasExternalLink = BTenantBilling.newProperty((int)256, (boolean)false, null);
    public static final Property externalLinkText = BTenantBilling.newProperty((int)256, (String)"", null);
    public static final Property externalLinkOrd = BTenantBilling.newProperty((int)256, (BValue)BOrd.NULL, null);
    public static final Property externalLinkImage = BTenantBilling.newProperty((int)256, (BValue)BOrd.NULL, null);
    public static final Property sendOverrideNotifications = BTenantBilling.newProperty((int)0, (boolean)false, null);
    public static final Property currencySymbol = BTenantBilling.newProperty((int)256, (String)"$", null);
    public static final Property unusedUserDuration = BTenantBilling.newProperty((int)4, (int)365, (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"day"), (int)0, (double)0.0, (double)3650.0));
    public static final Property invoiceFrom = BTenantBilling.newProperty((int)256, (BValue)BEmailAddress.NULL, null);
    public static final Property invoiceCc = BTenantBilling.newProperty((int)256, (BValue)BEmailAddressList.NULL, null);
    public static final Property invoiceBcc = BTenantBilling.newProperty((int)256, (BValue)BEmailAddressList.NULL, null);
    public static final Property ownerPageHeader = BTenantBilling.newProperty((int)256, (String)"TenantEye", null);
    public static final Property ownerName = BTenantBilling.newProperty((int)256, (String)"Owner", null);
    public static final Property ownerLine1 = BTenantBilling.newProperty((int)256, (String)"Address 1", null);
    public static final Property ownerLine2 = BTenantBilling.newProperty((int)256, (String)"Address 2", null);
    public static final Property ownerLine3 = BTenantBilling.newProperty((int)256, (String)"City, State, Zip", null);
    public static final Property ownerLine4 = BTenantBilling.newProperty((int)256, (String)"Phone 1", null);
    public static final Property ownerLine5 = BTenantBilling.newProperty((int)256, (String)"Phone 2", null);
    public static final Property ownerLine6 = BTenantBilling.newProperty((int)256, (String)"http://www.kodaro.com", null);
    public static final Property ownerLogo = BTenantBilling.newProperty((int)256, (BValue)BImage.make((BOrd)BOrd.make((String)"module://kodarotenant/img/KODARO_Logo_Light_Header.png")), null);
    public static final Property errorEmail = BTenantBilling.newProperty((int)256, (BValue)BEmailAddressList.NULL, null);
    public static final Property message = BTenantBilling.newProperty((int)258, (String)"", null);
    public static final Property messageEnabled = BTenantBilling.newProperty((int)258, (boolean)false, null);
    public static final Property OwnerHome = BTenantBilling.newProperty((int)256, (BValue)new BPxView(BOrd.make((String)"module://kodarotenant/px/OwnerHome.px")), null);
    public static final Property OwnerSetup = BTenantBilling.newProperty((int)256, (BValue)new BPxView(BOrd.make((String)"module://kodarotenant/px/OwnerSetup.px")), null);
    public static final Property OwnerMasterRates = BTenantBilling.newProperty((int)256, (BValue)new BPxView(BOrd.make((String)"module://kodarotenant/px/OwnerMasterRates.px")), null);
    public static final Property OwnerSuites = BTenantBilling.newProperty((int)256, (BValue)new BPxView(BOrd.make((String)"module://kodarotenant/px/OwnerSuites.px")), null);
    public static final Property SystemSetup = BTenantBilling.newProperty((int)256, (BValue)new BPxView(BOrd.make((String)"module://kodarotenant/px/SystemSetup.px")), null);
    public static final Property license = BTenantBilling.newProperty((int)256, (BValue)new BTbsLicense(), null);
    public static final Property pollScheduler = BTenantBilling.newProperty((int)260, (BValue)BTenantBilling.makePollScheduler(), null);
    public static final Property threadPool = BTenantBilling.newProperty((int)260, (BValue)BTenantBilling.makeThreadPool(), null);
    public static final Action addUser = BTenantBilling.newAction((int)260, (BValue)BString.DEFAULT, null);
    public static final Action clearMessage = BTenantBilling.newAction((int)256, null);
    public static final Action getHomePage = BTenantBilling.newAction((int)2308, null);
    public static final Action getUsers = BTenantBilling.newAction((int)2308, null);
    public static final Action getUserService = BTenantBilling.newAction((int)2308, null);
    public static final Action removeUser = BTenantBilling.newAction((int)260, (BValue)BString.DEFAULT, null);
    public static final Action updateUser = BTenantBilling.newAction((int)260, (BValue)new BComponent(), null);
    public static final Type TYPE = Sys.loadType(BTenantBilling.class);
    private static ArrayList instances = new ArrayList();
    private static BIcon icon = BIcon.std((String)"site.png");

    public boolean getUseMasterRateSchedule() {
        return this.getBoolean(useMasterRateSchedule);
    }

    public void setUseMasterRateSchedule(boolean v) {
        this.setBoolean(useMasterRateSchedule, v, null);
    }

    public BNumericSchedule getMasterRateSchedule() {
        return (BNumericSchedule)this.get(masterRateSchedule);
    }

    public void setMasterRateSchedule(BNumericSchedule v) {
        this.set(masterRateSchedule, (BValue)v, null);
    }

    public boolean getHasExternalLink() {
        return this.getBoolean(hasExternalLink);
    }

    public void setHasExternalLink(boolean v) {
        this.setBoolean(hasExternalLink, v, null);
    }

    public String getExternalLinkText() {
        return this.getString(externalLinkText);
    }

    public void setExternalLinkText(String v) {
        this.setString(externalLinkText, v, null);
    }

    public BOrd getExternalLinkOrd() {
        return (BOrd)this.get(externalLinkOrd);
    }

    public void setExternalLinkOrd(BOrd v) {
        this.set(externalLinkOrd, (BValue)v, null);
    }

    public BOrd getExternalLinkImage() {
        return (BOrd)this.get(externalLinkImage);
    }

    public void setExternalLinkImage(BOrd v) {
        this.set(externalLinkImage, (BValue)v, null);
    }

    public boolean getSendOverrideNotifications() {
        return this.getBoolean(sendOverrideNotifications);
    }

    public void setSendOverrideNotifications(boolean v) {
        this.setBoolean(sendOverrideNotifications, v, null);
    }

    public String getCurrencySymbol() {
        return this.getString(currencySymbol);
    }

    public void setCurrencySymbol(String v) {
        this.setString(currencySymbol, v, null);
    }

    public int getUnusedUserDuration() {
        return this.getInt(unusedUserDuration);
    }

    public void setUnusedUserDuration(int v) {
        this.setInt(unusedUserDuration, v, null);
    }

    public BEmailAddress getInvoiceFrom() {
        return (BEmailAddress)this.get(invoiceFrom);
    }

    public void setInvoiceFrom(BEmailAddress v) {
        this.set(invoiceFrom, (BValue)v, null);
    }

    public BEmailAddressList getInvoiceCc() {
        return (BEmailAddressList)this.get(invoiceCc);
    }

    public void setInvoiceCc(BEmailAddressList v) {
        this.set(invoiceCc, (BValue)v, null);
    }

    public BEmailAddressList getInvoiceBcc() {
        return (BEmailAddressList)this.get(invoiceBcc);
    }

    public void setInvoiceBcc(BEmailAddressList v) {
        this.set(invoiceBcc, (BValue)v, null);
    }

    public String getOwnerPageHeader() {
        return this.getString(ownerPageHeader);
    }

    public void setOwnerPageHeader(String v) {
        this.setString(ownerPageHeader, v, null);
    }

    public String getOwnerName() {
        return this.getString(ownerName);
    }

    public void setOwnerName(String v) {
        this.setString(ownerName, v, null);
    }

    public String getOwnerLine1() {
        return this.getString(ownerLine1);
    }

    public void setOwnerLine1(String v) {
        this.setString(ownerLine1, v, null);
    }

    public String getOwnerLine2() {
        return this.getString(ownerLine2);
    }

    public void setOwnerLine2(String v) {
        this.setString(ownerLine2, v, null);
    }

    public String getOwnerLine3() {
        return this.getString(ownerLine3);
    }

    public void setOwnerLine3(String v) {
        this.setString(ownerLine3, v, null);
    }

    public String getOwnerLine4() {
        return this.getString(ownerLine4);
    }

    public void setOwnerLine4(String v) {
        this.setString(ownerLine4, v, null);
    }

    public String getOwnerLine5() {
        return this.getString(ownerLine5);
    }

    public void setOwnerLine5(String v) {
        this.setString(ownerLine5, v, null);
    }

    public String getOwnerLine6() {
        return this.getString(ownerLine6);
    }

    public void setOwnerLine6(String v) {
        this.setString(ownerLine6, v, null);
    }

    public BImage getOwnerLogo() {
        return (BImage)this.get(ownerLogo);
    }

    public void setOwnerLogo(BImage v) {
        this.set(ownerLogo, (BValue)v, null);
    }

    public BEmailAddressList getErrorEmail() {
        return (BEmailAddressList)this.get(errorEmail);
    }

    public void setErrorEmail(BEmailAddressList v) {
        this.set(errorEmail, (BValue)v, null);
    }

    public String getMessage() {
        return this.getString(message);
    }

    public void setMessage(String v) {
        this.setString(message, v, null);
    }

    public boolean getMessageEnabled() {
        return this.getBoolean(messageEnabled);
    }

    public void setMessageEnabled(boolean v) {
        this.setBoolean(messageEnabled, v, null);
    }

    public BPxView getOwnerHome() {
        return (BPxView)this.get(OwnerHome);
    }

    public void setOwnerHome(BPxView v) {
        this.set(OwnerHome, (BValue)v, null);
    }

    public BPxView getOwnerSetup() {
        return (BPxView)this.get(OwnerSetup);
    }

    public void setOwnerSetup(BPxView v) {
        this.set(OwnerSetup, (BValue)v, null);
    }

    public BPxView getOwnerMasterRates() {
        return (BPxView)this.get(OwnerMasterRates);
    }

    public void setOwnerMasterRates(BPxView v) {
        this.set(OwnerMasterRates, (BValue)v, null);
    }

    public BPxView getOwnerSuites() {
        return (BPxView)this.get(OwnerSuites);
    }

    public void setOwnerSuites(BPxView v) {
        this.set(OwnerSuites, (BValue)v, null);
    }

    public BPxView getSystemSetup() {
        return (BPxView)this.get(SystemSetup);
    }

    public void setSystemSetup(BPxView v) {
        this.set(SystemSetup, (BValue)v, null);
    }

    public BTbsLicense getLicense() {
        return (BTbsLicense)this.get(license);
    }

    public void setLicense(BTbsLicense v) {
        this.set(license, (BValue)v, null);
    }

    public BTbsPollScheduler getPollScheduler() {
        return (BTbsPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BTbsPollScheduler v) {
        this.set(pollScheduler, (BValue)v, null);
    }

    public BTbsThreadPool getThreadPool() {
        return (BTbsThreadPool)this.get(threadPool);
    }

    public void setThreadPool(BTbsThreadPool v) {
        this.set(threadPool, (BValue)v, null);
    }

    public void addUser(BString arg) {
        this.invoke(addUser, (BValue)arg, null);
    }

    public void clearMessage() {
        this.invoke(clearMessage, null, null);
    }

    public BOrd getHomePage() {
        return (BOrd)this.invoke(getHomePage, null, null);
    }

    public BComponent getUsers() {
        return (BComponent)this.invoke(getUsers, null, null);
    }

    public BUserService getUserService() {
        return (BUserService)this.invoke(getUserService, null, null);
    }

    public void removeUser(BString arg) {
        this.invoke(removeUser, (BValue)arg, null);
    }

    public void updateUser(BComponent arg) {
        this.invoke(updateUser, (BValue)arg, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void configFatal(String msg) {
        this.setMessage(msg);
        this.setMessageEnabled(true);
    }

    public void configFail(String msg) {
        this.setMessage(msg);
        this.setMessageEnabled(true);
    }

    public void configOk() {
        this.setMessage("");
        this.setMessageEnabled(false);
    }

    public void doAddUser(BString name) {
        UserMgmt.addUser(this, name, true);
    }

    public void doClearMessage() {
        this.setMessageEnabled(false);
        this.setMessage("");
    }

    public BOrd doGetHomePage() {
        return UserMgmt.getHomePage(this, BBoolean.TRUE);
    }

    public BComponent doGetUsers() {
        return UserMgmt.getUsers(this);
    }

    public BUserService doGetUserService() {
        return UserMgmt.getUserService();
    }

    public void doRemoveUser(BString name) {
        UserMgmt.removeUser(name);
    }

    public void doUpdateUser(BComponent c) {
        UserMgmt.updateUsers(this, c);
    }

    public void enqueue(Runnable r) {
        this.getThreadPool().post(r);
    }

    public static void getAllInstances(Collection col) {
        col.addAll(instances);
    }

    public BIcon getIcon() {
        return icon;
    }

    public Log getLog() {
        return Log.getLog((String)"TenantEye");
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void handleError(BSuite tenant, String msg, Throwable t) {
        this.getLog().error(tenant.getName() + ": " + msg, t);
        try {
            StringBuffer buf = new StringBuffer();
            buf.append("Owner: ").append(this.getOwnerName());
            buf.append("\nTenant: ").append(tenant.getTenantName());
            buf.append("\nMessage: ").append(msg);
            buf.append("\nDetails:\n");
            buf.append(ThrowableUtil.dumpToString((Throwable)t));
            BEmail email = new BEmail(this.getErrorEmail(), "Tenant Billing Error", buf.toString());
            BEmailService emailService = (BEmailService)Sys.getService((Type)BEmailService.TYPE);
            emailService.send(email);
        }
        catch (Throwable x) {
            this.setMessage("Failure emailing error report, contact tech support!");
            this.setMessageEnabled(true);
        }
    }

    public void handleOverride(BSuite tenant, BOverrideEvent evt, Context cx) {
        if (!this.getSendOverrideNotifications()) {
            return;
        }
        try {
            String location = tenant.getAccount();
            String tenantName = tenant.getTenantName();
            StringBuffer buf = new StringBuffer();
            buf.append("Owner: ").append(this.getOwnerName());
            buf.append("\nLocation: ").append(location);
            buf.append("\nTenant: ").append(tenantName);
            if (cx != null) {
                buf.append("\nUser: ").append(cx.getUser().getUsername());
            }
            buf.append("\nStart: ").append(evt.getStart().toString(null));
            buf.append("\nEnd: ").append(evt.getEnd().toString(null));
            BEmail email = new BEmail(this.getInvoiceFrom(), "Scheduled Override " + tenantName + "/" + location, buf.toString());
            BEmailService emailService = (BEmailService)Sys.getService((Type)BEmailService.TYPE);
            emailService.send(email);
        }
        catch (Exception x) {
            this.getLog().error(this.toPathString(), (Throwable)x);
        }
    }

    public IFuture post(Action a, BValue arg, Context cx) {
        this.enqueue((Runnable)new Invocation((BComponent)this, a, arg, cx));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStarted() {
        ArrayList arrayList = instances;
        synchronized (arrayList) {
            BRole teManagerRole = new BRole();
            teManagerRole.setPermissions(BPermissionsMap.SUPER_USER);
            BRole teSuiteRole = new BRole();
            teSuiteRole.setPermissions(BPermissionsMap.SUPER_USER);
            BRoleService svc = BRoleService.getService();
            BValue role = svc.get("tenantEyeManager");
            if (role == null) {
                svc.add("tenantEyeManager", (BValue)teManagerRole);
            } else if (!(role instanceof BRole)) {
                svc.add("tenantEyeManager", (BValue)teManagerRole);
            }
            role = svc.get("tenantEyeSuiteUser");
            if (role == null) {
                svc.add("tenantEyeSuiteUser", (BValue)teSuiteRole);
            } else if (!(role instanceof BRole)) {
                svc.add("tenantEyeSuiteUser", (BValue)teSuiteRole);
            }
            BTbsUser[] users = (BTbsUser[])BUserService.getService().getChildren(BTbsUser.class);
            for (int i = 0; i < users.length; ++i) {
                BObject obj = users[i].getHomePage().get();
                String roles = users[i].getRoles();
                if (obj instanceof BTenantBilling) {
                    if (roles.contains("tenantEyeManager")) continue;
                    if (!roles.isEmpty()) {
                        roles = roles + ",";
                    }
                    roles = roles + "tenantEyeManager";
                    users[i].setRoles(roles);
                    continue;
                }
                if (roles.contains("tenantEyeSuiteUser")) continue;
                if (!roles.isEmpty()) {
                    roles = roles + ",";
                }
                roles = roles + "tenantEyeSuiteUser";
                users[i].setRoles(roles);
            }
        }
    }

    public void serviceStopped() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void started() throws Exception {
        try {
            super.started();
            ArrayList arrayList = instances;
            synchronized (arrayList) {
                instances.add(this);
            }
        }
        catch (ServiceNotFoundException e) {
            this.getLog().error("TenantEye not registered as a service.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopped() throws Exception {
        ArrayList arrayList = instances;
        synchronized (arrayList) {
            instances.remove((Object)this);
        }
        super.stopped();
    }

    static BPermissionsMap make(BPermissions p) {
        int len = 8;
        try {
            len = BCategoryService.getService().getCategories().length;
            if (len < 8) {
                len = 8;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        BPermissions[] ary = new BPermissions[len];
        int i = len;
        while (--i >= 0) {
            ary[i] = p;
        }
        return BPermissionsMap.make((BPermissions[])ary);
    }

    private static BNumericSchedule makeMasterSchedule() {
        BNumericSchedule ret = new BNumericSchedule();
        ret.setDefaultOutput((BStatusValue)new BStatusNumeric(0.0));
        ret.setFacets(BFacets.makeNumeric((int)2));
        return ret;
    }

    private static BTbsPollScheduler makePollScheduler() {
        BTbsPollScheduler ret = new BTbsPollScheduler();
        return ret;
    }

    private static BTbsThreadPool makeThreadPool() {
        BTbsThreadPool ret = new BTbsThreadPool();
        return ret;
    }
}

