/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant;

import com.kodaro.tenant.BOverrideEvent;
import com.kodaro.tenant.BSuite;
import com.kodaro.tenant.BTenantBilling;
import com.kodaro.tenant.IScheduledMeter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordCache;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.TimeZoneDatabase;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.web.BWebServlet;
import javax.baja.web.WebOp;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BTenantServlet
extends BWebServlet {
    public static final Property servletName = BTenantServlet.newProperty((int)0, (String)"tenant", null);
    public static final Property selectAllByDefault = BTenantServlet.newProperty((int)0, (boolean)true, null);
    public static final Property autoLogout = BTenantServlet.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)15), null);
    public static final Property showTimezone = BTenantServlet.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BTenantServlet.class);
    public static final String PAGE_EVENT_SCHEDULE = "es";
    public static final String PAGE_LOGGED_OUT = "lo";
    public static final String PAGE_MY_PROFILE = "mp";
    public static final String PAGE_SYSTEM_OVERRIDE = "so";
    public static final String ACTION_DELETE_EVENT = "de";
    public static final String ACTION_LOGOUT = "lo";
    public static final String ACTION_SYSTEM_OVERRIDE = "so";
    public static final String ACTION_UPDATE_USER = "uu";
    private static BIcon icon = BIcon.std((String)"web.png");
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("MMM-dd-yyyy");
    private static BFacets bajaFormat = BFacets.make((String)"timeFormat", (String)"MMM-DD-YYYY h:mma z");
    private static BTimeZone[] timezones;

    public boolean getSelectAllByDefault() {
        return this.getBoolean(selectAllByDefault);
    }

    public void setSelectAllByDefault(boolean v) {
        this.setBoolean(selectAllByDefault, v, null);
    }

    public BRelTime getAutoLogout() {
        return (BRelTime)this.get(autoLogout);
    }

    public void setAutoLogout(BRelTime v) {
        this.set(autoLogout, (BValue)v, null);
    }

    public boolean getShowTimezone() {
        return this.getBoolean(showTimezone);
    }

    public void setShowTimezone(boolean v) {
        this.setBoolean(showTimezone, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    public void service(WebOp op) throws Exception {
        try {
            if (!this.getEnabled()) {
                op.getResponse().sendError(410, "Disabled");
                return;
            }
            TenantContext cx = new TenantContext(op);
            BComponent comp = (BComponent)op.getUser().getHomePage().get((BObject)this);
            if (!(comp instanceof BSuite)) {
                op.getResponse().sendError(403, "Tenant access only.");
                return;
            }
            cx.suite = (BSuite)comp;
            cx.page = cx.param("pg", "so");
            if (!this.processActions(cx)) {
                return;
            }
            op.getResponse().setContentType("text/html");
            if (cx.page.equals(PAGE_EVENT_SCHEDULE)) {
                this.printEventsPage(cx);
            } else if (cx.page.equals(PAGE_MY_PROFILE)) {
                this.printProfilePage(cx);
            } else {
                this.printOverridePage(cx);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected boolean processActions(TenantContext cx) throws Exception {
        HttpServletRequest req = cx.getRequest();
        String action = req.getParameter("op");
        if (action == null) {
            return true;
        }
        if (action.equals("lo")) {
            HttpServletResponse res = cx.op.getResponse();
            Cookie[] c = req.getCookies();
            int i = c.length;
            while (--i >= 0) {
                c[i].setMaxAge(0);
                res.addCookie(c[i]);
            }
            res.sendRedirect("/" + this.getServletName());
            return false;
        }
        if (action.equals("so")) {
            String str = req.getParameter("date");
            Date date = new Date();
            if (!str.equalsIgnoreCase("Today")) {
                date = dateFormat.parse(str);
            }
            String tz = req.getParameter("tz");
            String hour = req.getParameter("start_hour");
            String min = req.getParameter("start_minute");
            String ampm = req.getParameter("start_ampm");
            BAbsTime begin = BAbsTime.make((long)date.getTime());
            int hourInt = Integer.parseInt(hour);
            if (ampm.equalsIgnoreCase("PM")) {
                if (hourInt < 12) {
                    hourInt += 12;
                }
            } else if (hourInt == 12) {
                hourInt = 0;
            }
            BTimeZone tzObj = cx.getTimeZone();
            if (tz != null) {
                tzObj = BTimeZone.getTimeZone((String)tz);
            }
            begin = BAbsTime.make((int)begin.getYear(), (BMonth)begin.getMonth(), (int)begin.getDay(), (int)hourInt, (int)Integer.parseInt(min), (int)0, (int)0, (BTimeZone)tzObj);
            hour = req.getParameter("end_hour");
            min = req.getParameter("end_minute");
            ampm = req.getParameter("end_ampm");
            BAbsTime end = BAbsTime.make((long)date.getTime());
            hourInt = Integer.parseInt(hour);
            if (ampm.equalsIgnoreCase("PM")) {
                if (hourInt < 12) {
                    hourInt += 12;
                }
            } else if (hourInt == 12) {
                hourInt = 0;
            }
            if ((end = BAbsTime.make((int)end.getYear(), (BMonth)end.getMonth(), (int)end.getDay(), (int)hourInt, (int)Integer.parseInt(min), (int)0, (int)0, (BTimeZone)tzObj)).isBefore(begin)) {
                end = end.nextDay();
            }
            String[] handles = req.getParameterValues("meter");
            int i = handles.length;
            while (--i >= 0) {
                IScheduledMeter m = (IScheduledMeter)BOrd.make((String)handles[i]).get((BObject)this);
                BOverrideEvent event = new BOverrideEvent();
                event.setStart(begin);
                event.setEnd(end);
                event.setUser(cx.op.getUser().getUsername());
                m.doOverride(event, (Context)cx.op);
            }
            cx.addMessage("Override scheduled");
        } else if (action.equals(ACTION_DELETE_EVENT)) {
            String[] handles = req.getParameterValues("evt");
            for (int i = 0; i < handles.length; ++i) {
                BOverrideEvent evt = (BOverrideEvent)BOrd.make((String)handles[i]).get((BObject)this);
                evt.getParent().asComponent().remove((BComplex)evt);
                cx.addMessage("Event successfully deleted");
            }
        } else if (action.equals(ACTION_UPDATE_USER)) {
            String confirm;
            String pass = cx.param("pass", "");
            if (!pass.equals(confirm = cx.param("confirm", ""))) {
                cx.addMessage("Passwords do not match");
                return true;
            }
            String arg = req.getParameter("user");
            BUser user = BUserService.getService().getUser(arg);
            if (!pass.equals("placeholder")) {
                BPasswordCache userPw = (BPasswordCache)user.getAuthenticator();
                userPw.setPassword(BPassword.make((String)pass));
            }
            arg = cx.param("full", user.getFullName());
            user.setFullName(arg);
            arg = cx.param("email", user.getEmail());
            user.setEmail(arg);
            arg = cx.param("cell", "");
            user.set("cellPhoneNumber", (BValue)BString.make((String)arg));
            cx.addMessage(user.getUsername() + " successfully updated");
            String tz = req.getParameter("tz");
            if (tz != null) {
                BTimeZone tzObj = BTimeZone.getTimeZone((String)tz);
                cx.setTimeZone(tzObj);
            }
        }
        return true;
    }

    static BAbsTime getTime(BTimeZone tz) {
        return BAbsTime.make((long)System.currentTimeMillis(), (BTimeZone)tz);
    }

    static BAbsTime getTime(long millis, BTimeZone tz) {
        return BAbsTime.make((long)millis, (BTimeZone)tz);
    }

    static BAbsTime getTime(BAbsTime time, BTimeZone tz) {
        return BTenantServlet.getTime(time.getMillis(), tz);
    }

    static BTimeZone[] getTimeZones() {
        if (timezones == null) {
            BTimeZone[] tzs = TimeZoneDatabase.get().getTimeZones();
            Comparator comp = new Comparator(){

                public int compare(Object o1, Object o2) {
                    BTimeZone tz1 = (BTimeZone)o1;
                    BTimeZone tz2 = (BTimeZone)o2;
                    return tz1.getId().compareTo(tz2.getId());
                }
            };
            Arrays.sort(tzs, comp);
            timezones = tzs;
        }
        return timezones;
    }

    private void printJsResource(String resourcePath, PrintWriter w) throws Exception {
        BOrd ord = BOrd.make((String)resourcePath);
        BIFile file = (BIFile)ord.get((BObject)this);
        w.println("<script>");
        w.write(new String(file.read()));
        w.println("</script>");
    }

    private void printBegin(TenantContext cx) throws Exception {
        BSuite suite = cx.suite;
        BTenantBilling owner = suite.getOwner();
        PrintWriter w = cx.getWriter();
        w.println("<html><head>");
        w.println("<link rel='stylesheet' type='text/css' src='href=/ord?module://kodarotenant/dtpicker/rfnet.css'/>");
        this.printJsResource("module://kodarotenant/dtpicker/datetimepicker_css.js", w);
        w.print("<script type='text/javascript'>");
        w.println("function autoLogout() {window.location='?op=lo'}</script>");
        w.println("</head>");
        w.print("<body bgcolor='#ffffff' style='font-family: Verdana, Arial, Helvetica, sans-serif;font-style: normal;' ");
        long millis = this.getAutoLogout().getMillis();
        if (millis > 0L) {
            w.print("onLoad=\"setTimeout('autoLogout()',");
            w.print(millis);
            w.print(")\"");
        }
        w.println("><center>");
        w.println("<table border='0' cellspacing='2' cellpadding='5' width='800'>");
        w.println("<tr><td><table border='0' width='100%'>");
        w.println("<tr valign='center'><td align='left'>");
        w.println("<img src='/ord?" + owner.getOwnerLogo().toString(null));
        w.println("'/>");
        w.println("</td><td align='right' style='font-size: x-large'>");
        String name = suite.getTenantName();
        if (name.length() == 0) {
            name = suite.getAccount();
        }
        if (name.length() == 0) {
            name = owner.getOwnerName();
        }
        if (name.length() == 0) {
            name = "TenantEye";
        }
        w.println(name);
        w.println("</td></tr></table></td></tr>");
        w.println("<tr><td bgcolor='#AFD775'>");
        w.println("<b><table border='0'> <tr><td>");
        if (cx.page.equals("so")) {
            w.println("<a href='?pg=so'><b>System Override</b></a>");
        } else {
            w.println("<a href='?pg=so'>System Override</a>");
        }
        w.println("|");
        if (cx.page.equals(PAGE_EVENT_SCHEDULE)) {
            w.println("<a href='?pg=es'><b>Event Schedule</b></a>");
        } else {
            w.println("<a href='?pg=es'>Event Schedule</a>");
        }
        w.println("|");
        if (cx.page.equals(PAGE_MY_PROFILE)) {
            w.println("<a href='?pg=mp'><b>My Profile</b></a>");
        } else {
            w.println("<a href='?pg=mp'>My Profile</a>");
        }
        w.println("</tr></table></b></td></tr>");
        w.println("<tr><td bgcolor='#95CBE9'>");
        Iterator it = cx.getMessages();
        if (it != null) {
            w.println("<center><table border='0' cellpadding='10'>");
            w.println("<tr style='color: #B80028'><td><ul>");
            while (it.hasNext()) {
                w.print("<li>");
                w.println(it.next().toString());
            }
            w.println("</ul></td></tr></table></center>");
        }
    }

    private void printEnd(TenantContext cx) throws Exception {
        PrintWriter w = cx.getWriter();
        w.println("</td></tr><tr><td bgcolor='#ffffff'>");
        w.println("<center>");
        w.println("<a href='?op=lo'>Logout</a>");
        w.println("</center>");
        w.println("</td></tr>");
        w.println("</table></center></body></html>");
    }

    private void printOverridePage(TenantContext cx) throws Exception {
        int i;
        this.printBegin(cx);
        PrintWriter w = cx.getWriter();
        w.println("<form action='' method='post'>");
        w.println("<input type='hidden' name='pg' value='es'/>");
        w.println("<input type='hidden' name='op' value='so'/>");
        w.println("<table border='0' cellpadding='10' width='100%'>");
        IScheduledMeter[] ary = (IScheduledMeter[])cx.suite.getChildren(IScheduledMeter.class);
        int len = ary.length;
        w.println("<tr><td><b>Systems</b></td><td>");
        for (int i2 = 0; i2 < ary.length; ++i2) {
            w.print(" <input type='checkbox' name='meter'");
            if (this.getSelectAllByDefault() || len == 1) {
                w.print(" checked");
            }
            w.print(" value='");
            w.print(ary[i2].asMeter().getHandleOrd().toString(null));
            w.print("'/> ");
            w.print(ary[i2].asMeter().getTitle());
            w.println("<br>");
        }
        w.println("</td></tr><tr><td><b>Date</b></td><td>");
        w.println("<input type='Text' readonly id='date' maxlength='25' size='25' name='date' value='Today' style='background: #fefefe;color: #000000;border: 2;padding: 2'/>");
        w.println("<a href=\"javascript:NewCssCal('date','mmmddyyyy','dropdown')\"><img src='/ord?module://kodarotenant/dtpicker/images/cal.gif' border='0'></a>");
        w.println("</td></tr>");
        w.println("<tr><td><b>Start</b></td><td><select name='start_hour' style='border: 1;padding: 2'>");
        BTimeZone tz = cx.getTimeZone();
        BAbsTime time = BTenantServlet.getTime(tz);
        time = time.add(BRelTime.HOUR);
        time = BAbsTime.make((int)time.getYear(), (BMonth)time.getMonth(), (int)time.getDay(), (int)time.getHour(), (int)0, (int)0, (int)0, (BTimeZone)time.getTimeZone());
        int cur = time.getHour() % 12;
        for (i = 1; i <= 12; ++i) {
            w.print("<option value='");
            w.print(i);
            w.print("' ");
            if (i == cur) {
                w.print("selected");
            }
            w.print(">");
            w.print(i);
            w.println("</option>");
        }
        w.println("</select><select name='start_minute' style='border: 1;padding: 2'>");
        cur = time.getMinute();
        for (i = 0; i < 60; i += 5) {
            w.print("<option value='");
            w.print(i);
            w.print("' ");
            if (i == 0) {
                w.print("selected");
            }
            w.print(">");
            if (i < 10) {
                w.print("0");
            }
            w.print(i);
            w.println("</option>");
        }
        w.println("</select><select name='start_ampm' style='border: 1;padding: 2'>");
        if (time.getHour() >= 12) {
            w.println("<option value='AM'>AM</option>");
            w.println("<option value='PM' selected>PM</option>");
        } else {
            w.println("<option value='AM' selected>AM</option>");
            w.println("<option value='PM'>PM</option>");
        }
        w.println("</select></td></tr>");
        w.println("<tr><td><b>End</b></td><td><select name='end_hour' style='border: 1;padding: 2'>");
        time = time.add(BRelTime.HOUR);
        cur = time.getHour() % 12;
        for (i = 1; i <= 12; ++i) {
            w.print("<option value='");
            w.print(i);
            w.print("' ");
            if (i == cur) {
                w.print("selected");
            }
            w.print(">");
            w.print(i);
            w.println("</option>");
        }
        w.println("</select><select name='end_minute' style='border: 1;padding: 2'>");
        cur = time.getMinute();
        for (i = 0; i < 60; i += 5) {
            w.print("<option value='");
            w.print(i);
            w.print("' ");
            if (i == 0) {
                w.print("selected");
            }
            w.print(">");
            if (i < 10) {
                w.print("0");
            }
            w.print(i);
            w.println("</option>");
        }
        w.println("</select><select name='end_ampm' style='border: 1;padding: 2'>");
        if (time.getHour() >= 12) {
            w.println("<option value='AM'>AM</option>");
            w.println("<option value='PM' selected>PM</option>");
        } else {
            w.println("<option value='AM' selected>AM</option>");
            w.println("<option value='PM'>PM</option>");
        }
        w.println("</select></td></tr>");
        if (this.getShowTimezone()) {
            w.println("<tr><td><b>Timezone</b></td><td><select name='tz' style='border: 1;padding: 2'>");
            BTimeZone[] tzs = BTenantServlet.getTimeZones();
            len = tzs.length;
            for (int i3 = 0; i3 < len; ++i3) {
                w.print("<option value='");
                w.print(tzs[i3].getId());
                w.print("' ");
                if (tzs[i3].equivalent((Object)tz)) {
                    w.print("selected");
                }
                w.print(">");
                w.print(tzs[i3].getId());
                w.println("</option>");
            }
            w.println("</select></td></tr>");
        }
        w.println("<tr><td colspan='2'><center>");
        w.println("<input type='submit' style='background: #fefefe; color: #000000; border: 1; padding: 4;' tabindex=1 value='&nbsp;&nbsp;Submit Override&nbsp;&nbsp;'/>");
        w.println("</center>");
        w.println("</td></tr></table>");
        w.println("</form>");
        this.printEnd(cx);
    }

    private void printEventsPage(TenantContext cx) throws Exception {
        this.printBegin(cx);
        PrintWriter w = cx.getWriter();
        w.println("<table border='0' cellpadding='10' width='100%'>");
        IScheduledMeter[] ary = (IScheduledMeter[])cx.suite.getChildren(IScheduledMeter.class);
        int len = ary.length;
        for (int i = 0; i < len; ++i) {
            w.print("<tr><td><b><i>");
            w.print(ary[i].asMeter().getTitle());
            w.println("</i></b><p>");
            w.println("<table width='100%' bgcolor='#ffffff' border='1' cellpadding='5' cellspacing='0'>");
            w.println("<tr><th width='40%'>Start</th><th width='40%'>End</th><th width='20%'>Scheduler</th><th>&nbsp;</th></tr>");
            BOverrideEvent[] evts = ary[i].getFutureEvents();
            BTimeZone tz = cx.getTimeZone();
            for (int j = 0; j < evts.length; ++j) {
                w.print("<tr><td>");
                w.print(BTenantServlet.getTime(evts[j].getStart(), tz).toString((Context)bajaFormat));
                w.print("</td><td>");
                w.print(BTenantServlet.getTime(evts[j].getEnd(), tz).toString((Context)bajaFormat));
                w.print("</td><td>");
                w.print(evts[j].getUser());
                w.print("</td><td><a href='?op=de&pg=es&evt=");
                w.print(evts[j].getHandleOrd().toString(null));
                w.println("'><img border='0' src='ord?module://icons/x16/trashCan.png'/></a></td></tr>");
            }
            w.println("</table>");
        }
        w.println("</td></tr></table>");
        this.printEnd(cx);
    }

    private void printProfilePage(TenantContext cx) throws Exception {
        cx.user = cx.op.getUser();
        this.printBegin(cx);
        this.printUserPage(cx);
        this.printEnd(cx);
    }

    private void printUserPage(TenantContext cx) throws Exception {
        BUser user = cx.user;
        PrintWriter w = cx.getWriter();
        w.println("<table border='0' cellpadding='10' width='100%'>");
        w.println("<form action='' method='post'>");
        w.print("<input type='hidden' name='user' value='");
        w.print(user.getName());
        w.println("'/>");
        w.println("<input type='hidden' name='op' value='uu'/>");
        w.println("<input type='hidden' name='pg' value='mp'/>");
        w.print("<tr><td><b>User</b></td><td>");
        w.println(user.getUsername());
        w.print("</td></tr><tr><td><b>Full Name</b></td><td>");
        w.print("<input type='Text' size='40' name='full' value='");
        w.print(user.getFullName());
        w.println("' style='background: #fefefe;color: #000000;border: 1;padding: 2'/>");
        w.print("</td></tr><tr><td><b>Email Address</b></td><td>");
        w.print("<input type='Text' size='40' name='email' value='");
        w.print(user.getEmail());
        w.println("' style='background: #fefefe;color: #000000;border: 1;padding: 2'/>");
        BValue o = user.get("cellPhoneNumber");
        if (o != null) {
            w.print("</td></tr><tr><td><b>Mobile Phone Number</b></td><td>");
            w.print("<input type='Text' size='40' name='cell' value='");
            w.print(o.toString(null));
            w.println("' style='background: #fefefe;color: #000000;border: 1;padding: 2'/>");
        }
        w.print("</td></tr>");
        if (this.getShowTimezone()) {
            w.print("<tr><td><b>Preferred Time Zone</b></td><td>");
            w.println("<select name='tz' style='border: 1;padding: 2'>");
            BTimeZone[] tzs = BTenantServlet.getTimeZones();
            BTimeZone curTz = cx.getTimeZone();
            int len = tzs.length;
            for (int i = 0; i < len; ++i) {
                w.print("<option value='");
                w.print(tzs[i].getId());
                w.print("' ");
                if (tzs[i].equivalent((Object)curTz)) {
                    w.print("selected");
                }
                w.print(">");
                w.print(tzs[i].getId());
                w.println("</option>");
            }
            w.println("</select>");
            w.print("</td></tr>");
        }
        w.print("<tr><td><b>Password</b></td><td>");
        w.print("<input type='Password' size='40' name='pass' value='");
        w.print("placeholder");
        w.println("' style='background: #fefefe;color: #000000;border: 1;padding: 2'/>");
        w.print("</td></tr><tr><td><b>Confirm Password</b></td><td>");
        w.print("<input type='Password' size='40' name='confirm' value='");
        w.print("placeholder");
        w.println("' style='background: #fefefe;color: #000000;border: 1;padding: 2'/>");
        w.println("</td><tr><td colspan='2'><center><input type='submit' style='background: #fefefe; color: #000000; border: 1; padding: 4;' tabindex=1 value='&nbsp;&nbsp;Submit&nbsp;&nbsp;'/></center></td></td>");
        w.println("</table>");
    }

    private String replace(String src, String tok, String neu) {
        if (src == null) {
            return null;
        }
        int to = src.indexOf(tok);
        if (to < 0) {
            return src;
        }
        StringBuffer buf = new StringBuffer();
        int from = 0;
        int toklen = tok.length();
        while (to >= 0) {
            buf.append(src.substring(from, to));
            buf.append(neu);
            from = to + toklen;
            to = src.indexOf(tok, from);
        }
        if (from < src.length()) {
            buf.append(src.substring(from));
        }
        return buf.toString();
    }

    private class TenantContext {
        public ArrayList messages;
        public WebOp op;
        public String page;
        public BSuite suite;
        public BUser user;

        TenantContext(WebOp op) {
            this.op = op;
        }

        public void addMessage(String message) {
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.add(message);
        }

        public Iterator getMessages() {
            if (this.messages == null) {
                return null;
            }
            return this.messages.iterator();
        }

        public HttpServletRequest getRequest() {
            return this.op.getRequest();
        }

        public BTimeZone getTimeZone() {
            BUser u = this.op.getUser();
            BTimeZone ret = (BTimeZone)u.getFacets().get("TimeZone");
            if (ret != null) {
                return ret;
            }
            return BTimeZone.getLocal();
        }

        public PrintWriter getWriter() throws Exception {
            return this.op.getWriter();
        }

        public String param(String key, String def) {
            String ret = this.op.getRequest().getParameter(key);
            if (ret == null) {
                return def;
            }
            return ret;
        }

        public void setTimeZone(BTimeZone tz) {
            if (tz.equivalent((Object)this.getTimeZone())) {
                return;
            }
            BUser u = this.op.getUser();
            BFacets f = u.getFacets();
            f = BFacets.make((BFacets)f, (String)"TimeZone", (BIDataValue)tz);
            u.setFacets(f);
        }
    }
}

