/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant;

import com.kodaro.tenant.BSuite;
import com.kodaro.tenant.BTbsUser;
import com.kodaro.tenant.BTenantBilling;
import com.kodaro.tenant.ui.BTbsProfile;
import com.kodaro.tenant.util.UserUtils;
import java.util.ArrayList;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.security.BPasswordCache;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.web.BWebProfileConfig;

public class UserMgmt {
    public static void addUser(BComponent tbsObject, BString name, boolean owner) {
        BTbsUser user;
        BUserService svc = BUserService.getService();
        BUser u = (BUser)svc.get(name.getString());
        if (u != null) {
            boolean taken = true;
            try {
                if (u instanceof BTbsUser) {
                    u.getHomePage();
                }
            }
            catch (Exception x) {
                taken = false;
            }
            if (taken) {
                throw new IllegalArgumentException("Login already in use.");
            }
        }
        if ((user = (BTbsUser)u) == null) {
            user = new BTbsUser();
            UserUtils.addUser(UserMgmt.makePath(tbsObject), name.getString(), user);
        }
        user.setHomePage(UserMgmt.getHomePage(tbsObject, BBoolean.FALSE));
        Property prop = UserMgmt.getWebProfile(user);
        BWebProfileConfig profile = new BWebProfileConfig();
        profile.setTypeSpec(BTbsProfile.TYPE.getTypeSpec());
        user.set(prop, (BValue)profile);
    }

    public static BOrd getHomePage(BComponent tbsObject, BBoolean manager) {
        if (tbsObject instanceof BSuite) {
            if (manager.getBoolean()) {
                return BOrd.make((String)("station:|" + tbsObject.getHandleOrd() + "|view:SuiteMgrHome"));
            }
            return BOrd.make((String)("station:|" + tbsObject.getHandleOrd() + "|view:SuiteHome"));
        }
        return BOrd.make((String)("station:|" + tbsObject.getHandleOrd() + "|view:OwnerHome"));
    }

    public static BTenantBilling getTenantBilling(BObject object) {
        if (object instanceof BUser) {
            object = ((BUser)object).getHomePage();
        }
        if (object instanceof BSuite) {
            return ((BSuite)object).getOwner();
        }
        if (object instanceof BTenantBilling) {
            return (BTenantBilling)object;
        }
        return null;
    }

    public static BUserService getUserService() {
        return BUserService.getService();
    }

    public static BComponent getUsers(BComponent tbsObject) {
        BUserService comp = BUserService.getService();
        BUser[] kids = UserUtils.getUsers(UserMgmt.makePath(tbsObject));
        BComponent ret = new BComponent();
        for (int i = 0; i < kids.length; ++i) {
            try {
                if (kids[i].getHomePage().resolve((BObject)tbsObject).getComponent() != tbsObject) continue;
                ret.add(kids[i].getName(), kids[i].newCopy(true));
                continue;
            }
            catch (Exception x) {
                Log.getLog((String)"TenantEye").warning("Cannot resolve home page of user: " + kids[i].getUsername());
            }
        }
        return ret;
    }

    public static Property getWebProfile(BUser user) {
        Property[] props = user.getPropertiesArray();
        int i = props.length;
        while (--i >= 0) {
            if (props[i].getType() != BWebProfileConfig.TYPE) continue;
            return props[i];
        }
        return null;
    }

    public static String[] makePath(BComponent tbsObject) {
        ArrayList path = new ArrayList();
        if (tbsObject instanceof BSuite) {
            BSuite suite = (BSuite)tbsObject;
            BTenantBilling tbs = suite.getOwner();
            return new String[]{"TenantEye", tbs.getName(), suite.getName()};
        }
        return new String[]{"TenantEye", tbsObject.getName()};
    }

    public static void removeUser(BString name) {
        UserUtils.removeUser(name.getString());
    }

    public static void updateUsers(BComponent tbsObject, BComponent users) {
        BUser[] ary = (BUser[])users.getChildren(BUser.class);
        BUserService svc = BUserService.getService();
        for (int i = 0; i < ary.length; ++i) {
            BTbsUser master = (BTbsUser)svc.getUser(ary[i].getUsername());
            master.setEmail(ary[i].getEmail());
            master.setEnabled(ary[i].getEnabled());
            master.setExpiration(ary[i].getExpiration());
            master.setHomePage(ary[i].getHomePage());
            master.setFullName(ary[i].getFullName());
            BPasswordCache userPw = (BPasswordCache)master.getAuthenticator();
            BPasswordCache aryPw = (BPasswordCache)ary[i].getAuthenticator();
            userPw.setPassword(aryPw.getPassword());
            master.setRoles(ary[i].getRoles());
        }
    }
}

