/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant.license;

import com.kodaro.tenant.license.LicenseMgr;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BAbstractLicense
extends BComponent {
    public static final Property status = BAbstractLicense.newProperty((int)3, (String)"", null);
    public static final Property productCode = BAbstractLicense.newProperty((int)3, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)40)));
    public static final Property licenseKey = BAbstractLicense.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)40)));
    public static final Property version = BAbstractLicense.newProperty((int)4, (int)0, null);
    public static final Type TYPE = Sys.loadType(BAbstractLicense.class);
    private static BIcon icon = BIcon.std((String)"lock.png");
    protected String code = null;
    private boolean starting = true;

    public String getStatus() {
        return this.getString(status);
    }

    public void setStatus(String v) {
        this.setString(status, v, null);
    }

    public String getProductCode() {
        return this.getString(productCode);
    }

    public void setProductCode(String v) {
        this.setString(productCode, v, null);
    }

    public String getLicenseKey() {
        return this.getString(licenseKey);
    }

    public void setLicenseKey(String v) {
        this.setString(licenseKey, v, null);
    }

    public int getVersion() {
        return this.getInt(version);
    }

    public void setVersion(int v) {
        this.setInt(version, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void changed(Property p, Context cx) {
        if (this.isRunning() && !this.starting) {
            if (p == licenseKey) {
                this.setStatus("Please restart the station");
                LicenseMgr.updateLicense(this);
            } else if (Flags.isUserDefined1((BComplex)this, (Slot)p)) {
                this.makeCode();
                if (!this.code.equals(this.getProductCode())) {
                    this.setStatus("Please restart the station");
                }
                this.setProductCode(this.code);
                LicenseMgr.updateLicense(this);
            }
        }
        super.changed(p, cx);
    }

    public BIcon getIcon() {
        return icon;
    }

    public void started() throws Exception {
        this.starting = true;
        try {
            LicenseMgr.loadLicense(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.makeCode();
        this.setProductCode(this.code);
        if (this.getVersion() == 0) {
            this.setVersion(1);
        }
        this.starting = false;
        super.started();
    }

    public final String toString(Context cx) {
        if (!this.getStatus().equals("")) {
            return this.getStatus();
        }
        return super.toString(cx);
    }

    protected String getId() {
        return this.getType().getModule().getModuleName();
    }

    protected Map getOptions() {
        TreeMap<String, BValue> ret = new TreeMap<String, BValue>();
        Property[] props = this.getPropertiesArray();
        int i = props.length;
        while (--i >= 0) {
            if (!Flags.isUserDefined1((BComplex)this, (Slot)props[i])) continue;
            ret.put(props[i].getName(), this.get(props[i]));
        }
        return ret;
    }

    protected void makeCode() {
        this.code = LicenseMgr.getHostId() + ":" + this.getId();
        Map m = this.getOptions();
        Iterator i = m.keySet().iterator();
        while (i.hasNext()) {
            this.code = this.code + ":" + m.get(i.next());
        }
        this.code = this.code.toUpperCase();
        this.code = this.code.replace(' ', '-');
        this.code = this.code.replace('O', '0');
    }

    protected void setOption(String key, String value) {
        try {
            BSimple s = (BSimple)this.get(key);
            BSimple neu = (BSimple)s.decodeFromString(value);
            this.set(key, (BValue)neu);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }
}

