/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant.license;

import com.kodaro.tenant.license.BAbstractLicense;
import com.tridium.platform.BSystemPlatformService;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

public class LicenseMgr {
    private LicenseMgr() {
    }

    public static synchronized void loadLicense(BAbstractLicense base) {
        try {
            License l = LicenseMgr.load(base);
            Product p = l.getProduct(base.getId());
            if (p == null) {
                l.setProduct(LicenseMgr.updateProduct(base, new Product(base.getId(), base.getLicenseKey())));
                LicenseMgr.save(base, l);
            } else {
                if (p.key != null) {
                    base.setLicenseKey(p.key);
                }
                for (String key : p.options.keySet()) {
                    base.setOption(key, (String)p.options.get(key));
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static String getHostId() {
        return ((BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE)).getHostId();
    }

    public static synchronized void updateLicense(BAbstractLicense base) {
        try {
            License l = LicenseMgr.load(base);
            Product p = l.getProduct(base.getId());
            if (p == null) {
                l.setProduct(LicenseMgr.updateProduct(base, new Product(base.getId(), base.getLicenseKey())));
            } else {
                l.setProduct(LicenseMgr.updateProduct(base, p));
            }
            LicenseMgr.save(base, l);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    protected static License load(BAbstractLicense base) throws Exception {
        BIFile sys = (BIFile)BOrd.make((String)"file:^").resolve((BObject)base, null).get();
        FilePath path = new FilePath("^license.kodaro");
        BIFile file = sys.getFileSpace().makeFile(path);
        if (file.getSize() == 0L) {
            License l = new License();
            l.hid = LicenseMgr.getHostId();
            XElem e = LicenseMgr.encodeLicense(l);
            OutputStream out = file.getOutputStream();
            XWriter w = new XWriter(out);
            e.write(w);
            w.close();
            return l;
        }
        XParser p = XParser.make((InputStream)file.getInputStream());
        return LicenseMgr.decodeLicense(p.parse(true));
    }

    protected static License decodeLicense(XElem e) {
        License ret = new License();
        ret.hid = e.get("hid", null);
        e = e.elem("current");
        XElem[] products = e.elems();
        int i = products.length;
        while (--i >= 0) {
            ret.setProduct(LicenseMgr.decodeProduct(products[i]));
        }
        return ret;
    }

    protected static Product decodeProduct(XElem e) {
        Product ret = new Product(e.name(), e.get("key", ""));
        XElem[] options = e.elems();
        int i = options.length;
        while (--i >= 0) {
            ret.setOption(options[i].name(), options[i].string());
        }
        return ret;
    }

    protected static XElem encodeLicense(License l) {
        XElem ret = new XElem("license");
        ret.setAttr("hid", l.hid);
        ret.setAttr("version", "1");
        XElem cur = new XElem("current");
        ret.addContent((XContent)cur);
        Iterator it = l.products.keySet().iterator();
        while (it.hasNext()) {
            cur.addContent((XContent)LicenseMgr.encodeProduct(l.getProduct((String)it.next())));
        }
        return ret;
    }

    protected static XElem encodeProduct(Product p) {
        String id = p.id;
        XElem ret = new XElem(id);
        if (id.indexOf(":") > 0) {
            String ns = id.substring(0, id.indexOf(":"));
            ret.defineNs(ns, "http://www.kodaro.com/" + ns);
        }
        if (p.key != null) {
            ret.setAttr("key", p.key);
        }
        for (String option : p.options.keySet()) {
            XElem opt = new XElem(option);
            opt.addText(p.getOption(option));
            ret.addContent((XContent)opt);
        }
        return ret;
    }

    protected static void save(BAbstractLicense base, License license) throws Exception {
        BIFile sys = (BIFile)BOrd.make((String)"file:^").resolve((BObject)base, null).get();
        FilePath path = new FilePath("^license.kodaro");
        BIFile file = sys.getFileSpace().makeFile(path);
        XElem e = LicenseMgr.encodeLicense(license);
        OutputStream out = file.getOutputStream();
        XWriter w = new XWriter(out);
        e.write(w);
        w.close();
    }

    protected static Product updateProduct(BAbstractLicense base, Product p) throws Exception {
        p.id = base.getId();
        String key = base.getLicenseKey();
        if (!key.equals("")) {
            p.key = key;
        }
        Map options = base.getOptions();
        for (String option : options.keySet()) {
            String val = ((BSimple)options.get(option)).encodeToString();
            p.setOption(option, val);
        }
        return p;
    }

    public static class Product {
        public String id;
        public String key;
        public Map options = new TreeMap();

        public Product(String id, String key) {
            this.id = id;
            this.key = key;
        }

        public String getOption(String name) {
            if (this.options == null) {
                return null;
            }
            return (String)this.options.get(name);
        }

        public void setOption(String name, String value) {
            if (this.options == null) {
                this.options = new TreeMap();
            }
            this.options.put(name, value);
        }
    }

    public static class License {
        public String hid;
        public TreeMap products = new TreeMap();

        public Product getProduct(String id) {
            return (Product)this.products.get(id);
        }

        public void setProduct(Product p) {
            this.products.put(p.id, p);
        }
    }
}

