/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant.ui;

import com.kodaro.tenant.BInvoice;
import com.kodaro.tenant.BMeterSummary;
import com.kodaro.tenant.util.BComplexTable;
import com.tridium.hx.px.BHxWidgetShell;
import javax.baja.gx.BFont;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.BWbShell;

public class BConsolidatedMeters
extends BGridPane {
    public static final Type TYPE = Sys.loadType(BConsolidatedMeters.class);
    private boolean built = false;
    public static BInvoice invoice = null;

    public Type getType() {
        return TYPE;
    }

    public BConsolidatedMeters() {
        super(4);
        this.buildTable();
    }

    public void doLayout(BWidget[] kids) {
        this.buildTable();
        super.doLayout(kids);
    }

    public void started() throws Exception {
        this.buildTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildTable() {
        BConsolidatedMeters bConsolidatedMeters = this;
        synchronized (bConsolidatedMeters) {
            if (this.built) {
                return;
            }
        }
        BInvoice parent = this.get();
        if (parent == null) {
            return;
        }
        BComplexTable table = parent.getMeterSummaries();
        BMeterSummary[] meters = (BMeterSummary[])table.getChildren(BMeterSummary.class);
        if (meters == null || meters.length == 0) {
            return;
        }
        BConsolidatedMeters bConsolidatedMeters2 = this;
        synchronized (bConsolidatedMeters2) {
            this.built = true;
        }
        this.removeAll();
        BConsolidatedMeters gp = this;
        gp.add(null, (BValue)new BLabel("Meter"));
        gp.add(null, (BValue)new BLabel("Quantity"));
        gp.add(null, (BValue)new BLabel("Avg Rate"));
        gp.add(null, (BValue)new BLabel("Cost"));
        BFont d = BFont.DEFAULT;
        BFont f = BFont.make((String)d.getName(), (double)10.0);
        gp.add(null, (BValue)new BLabel(" ", f));
        gp.add(null, (BValue)new BLabel(" ", f));
        gp.add(null, (BValue)new BLabel(" ", f));
        gp.add(null, (BValue)new BLabel(" ", f));
        for (int i = 0; i < meters.length; ++i) {
            gp.add(null, (BValue)new BLabel(meters[i].getMeter(), f));
            gp.add(null, (BValue)new BLabel(meters[i].getQuantity(), f));
            gp.add(null, (BValue)new BLabel(meters[i].getAverageRate(), f));
            gp.add(null, (BValue)new BLabel(meters[i].getAmount(), f));
        }
        invoice = null;
    }

    protected BInvoice get() {
        try {
            BWbShell shell;
            BComponent targ;
            if (invoice != null) {
                return invoice;
            }
            if (this.getShell() instanceof BWbShell && (targ = (BComponent)(shell = (BWbShell)this.getShell()).getActiveOrdTarget().get()) instanceof BInvoice) {
                return (BInvoice)targ;
            }
            for (BComplex c = this.getParent(); c != null; c = c.getParent()) {
                BInvoice ret;
                if (c instanceof BWbEditor) {
                    ret = (BInvoice)((BWbEditor)c).getCurrentValue();
                    ret.lease(1);
                    return ret;
                }
                if (!(c instanceof BHxWidgetShell)) continue;
                ret = (BInvoice)((BHxWidgetShell)c).getActiveOrdTarget().get();
                ret.lease(1, 1000L);
                return ret;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

