/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant.ui;

import com.kodaro.tenant.BOverrideEvent;
import com.kodaro.tenant.IScheduledMeter;
import java.util.Vector;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.sys.Action;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWindow;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.workbench.view.BWbComponentView;

public class BFutureEvents
extends BWbComponentView {
    public static final Action deleteRows = BFutureEvents.newAction((int)256, null);
    public static final Type TYPE = Sys.loadType(BFutureEvents.class);
    static final BImage imgClose = BImage.make((BIcon)BIcon.std((String)"close.png"));
    static final BImage imgDelete = BImage.make((BIcon)BIcon.make((String)"module://kodarotenant/img/delete.png"));
    BButton butClose;
    BButton butDel;
    Context cx;
    BOverrideEvent[] overrides;
    IScheduledMeter meter;
    BCompositeSchedule specialEvents;
    BTable table;

    public void deleteRows() {
        this.invoke(deleteRows, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doClose() {
        for (BFutureEvents cur = this; cur != null; cur = cur.getParent()) {
            if (!(cur instanceof BWindow)) continue;
            ((BWindow)cur).close();
            return;
        }
    }

    public void doDeleteRows() {
        int[] r = this.table.getSelection().getRows();
        if (r == null || r.length == 0) {
            return;
        }
        for (int i = 0; i < r.length; ++i) {
            this.meter.cancelOverride(BString.make((String)this.overrides[r[i]].getName()));
            this.overrides[r[i]] = null;
        }
        Vector<BOverrideEvent> v = new Vector<BOverrideEvent>();
        for (int i = 0; i < this.overrides.length; ++i) {
            if (this.overrides[i] == null) continue;
            v.addElement(this.overrides[i]);
        }
        this.overrides = new BOverrideEvent[v.size()];
        v.copyInto((Object[])this.overrides);
        this.butDel.setEnabled(false);
        this.table.getSelection().deselectAll();
        this.table.getModel().updateTable();
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.meter = (IScheduledMeter)value;
        value.asComponent().lease(10);
        this.specialEvents = this.meter.getOverrideSchedule().getSpecialEvents();
        this.overrides = this.meter.getFutureEvents();
        this.setContent(this.makeTable());
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        return value;
    }

    private BWidget makeTable() {
        this.table = new BTable((TableModel)new Model(), (TableController)new Controller());
        this.table.setOptionsButtonVisible(false);
        this.butClose = new BButton((Command)new CmdClose());
        this.butClose.setButtonStyle(BButtonStyle.toolBar);
        this.butClose.setBackground(BBrush.makeImage((BImage)BImage.NULL));
        this.butDel = new BButton((Command)new CmdDelete());
        this.butDel.setButtonStyle(BButtonStyle.toolBar);
        this.butDel.setBackground(BBrush.makeImage((BImage)BImage.NULL));
        BGridPane gp = new BGridPane(2);
        gp.setUniformColumnWidth(true);
        gp.setHalign(BHalign.center);
        gp.add(null, (BValue)this.butDel);
        gp.add(null, (BValue)this.butClose);
        BEdgePane ep = new BEdgePane();
        ep.setCenter((BWidget)this.table);
        ep.setBottom((BWidget)gp);
        return ep;
    }

    private class Model
    extends TableModel {
        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Start";
                }
                case 1: {
                    return "Hours";
                }
                case 2: {
                    return "Scheduler";
                }
            }
            throw new IllegalArgumentException("Unexpected column: " + col);
        }

        public int getRowCount() {
            if (BFutureEvents.this.overrides == null) {
                return 0;
            }
            return BFutureEvents.this.overrides.length;
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return BFutureEvents.this.overrides[row].getStart();
                }
                case 1: {
                    return BFutureEvents.this.overrides[row].duration();
                }
                case 2: {
                    return BFutureEvents.this.overrides[row].getUser();
                }
            }
            throw new IllegalArgumentException("Unexpected column: " + col);
        }
    }

    private class CmdDelete
    extends Command {
        CmdDelete() {
            super((BWidget)BFutureEvents.this, "Delete Selection", imgDelete, null, null);
        }

        public CommandArtifact doInvoke() {
            BFutureEvents.this.doDeleteRows();
            return null;
        }
    }

    private class CmdClose
    extends Command {
        CmdClose() {
            super((BWidget)BFutureEvents.this, "Close Window", imgClose, null, null);
        }

        public CommandArtifact doInvoke() {
            BFutureEvents.this.doClose();
            return null;
        }
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        protected void backgroundPopup(BMouseEvent e) {
            BMenu menu = new BMenu();
            if (BFutureEvents.this.table.getSelection().getRowCount() > 0) {
                menu.add(null, (Command)new CmdDelete());
                menu.open((BWidget)this.getTable(), e.getX(), e.getY());
            }
            menu.add(null, (Command)new CmdClose());
        }

        protected void cellPopup(BMouseEvent e, int row, int column) {
            BMenu menu = new BMenu();
            menu.add(null, (Command)new CmdDelete());
            menu.add(null, (Command)new CmdClose());
            menu.open((BWidget)this.getTable(), e.getX(), e.getY());
        }

        public void mousePressed(BMouseEvent e) {
            if (BFutureEvents.this.table.getSelection().getRowCount() > 0) {
                BFutureEvents.this.butDel.setEnabled(true);
            } else {
                BFutureEvents.this.butDel.setEnabled(false);
            }
            super.mousePressed(e);
        }

        public void mouseReleased(BMouseEvent e) {
            if (BFutureEvents.this.table.getSelection().getRowCount() > 0) {
                BFutureEvents.this.butDel.setEnabled(true);
            } else {
                BFutureEvents.this.butDel.setEnabled(false);
            }
            super.mouseReleased(e);
        }
    }
}

