/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant.ui;

import com.kodaro.tenant.ui.BNeedle;
import com.tridium.hx.gx.HxGraphics;
import javax.baja.gx.BImage;
import javax.baja.gx.BTransform;
import javax.baja.hx.HxOp;
import javax.baja.hx.PropertiesCollection;
import javax.baja.hx.px.BHxPxWidget;
import javax.baja.io.HtmlWriter;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BHxPxNeedle
extends BHxPxWidget {
    public static final BHxPxNeedle INSTANCE = new BHxPxNeedle();
    public static final Type TYPE = Sys.loadType(BHxPxNeedle.class);
    double angle;
    BImage fg;
    double fw;
    double fh;
    double fx;
    double fy;
    BImage rot;
    double rw;
    double rh;
    double rx;
    double ry;

    public Type getType() {
        return TYPE;
    }

    protected BHxPxNeedle() {
    }

    public void write(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<canvas style='vertical-align: center;horizontal-align: center;' ").attr("width", 0).w((Object)" ").attr("height", 0).w((Object)" ").attr("id", op.scope("canvas")).w((Object)"></canvas>");
    }

    public void update(int width, int height, boolean forceUpdate, HxOp op) throws Exception {
        BNeedle needle = (BNeedle)op.get();
        needle.loadSlots();
        this.rotate(needle);
        height = Math.max(0, height);
        width = Math.max(0, width);
        PropertiesCollection.Properties properties = new PropertiesCollection.Properties();
        properties.add("height", "" + height);
        properties.add("width", "" + width);
        properties.write(op.scope("canvas"), op);
        PropertiesCollection.Styles shapeStyles = new PropertiesCollection.Styles();
        shapeStyles.add("overflow", "visible");
        shapeStyles.write(op);
        PropertiesCollection.Styles canvasStyles = new PropertiesCollection.Styles();
        canvasStyles.add("position", "relative");
        canvasStyles.add("top", "0px");
        canvasStyles.add("left", "0px");
        canvasStyles.write(op.scope("canvas"), op);
        HxGraphics g = HxGraphics.make((HxOp)op, (String)op.scope("canvas"), (int)Math.max(0, width), (int)Math.max(0, height));
        g.push();
        g.clear(width, height);
        g.transform(BTransform.makeTranslate((double)0.0, (double)0.0));
        g.drawImage(this.rot, this.rx, this.ry);
        g.pop();
        g.dispose();
    }

    public void rotate(BNeedle needle) {
        this.fg = needle.getNeedle();
        if (this.fg == null) {
            return;
        }
        this.angle = needle.getAngle();
        if (this.angle == 0.0 || this.angle == 360.0) {
            this.rot = this.fg;
            this.rw = this.fw;
            this.rh = this.fh;
            this.layout(needle);
            return;
        }
        BTransform t = BTransform.makeRotate((double)this.angle);
        this.rot = this.fg.transform(t);
        this.rw = this.rot.getWidth();
        this.rh = this.rot.getHeight();
        this.layout(needle);
    }

    public void layout(BNeedle needle) {
        this.fx = (needle.getWidth() - this.fw) / 2.0;
        this.fy = (needle.getHeight() - this.fh) / 2.0;
        this.rx = (this.fw - this.rw) / 2.0 + this.fx;
        this.ry = (this.fh - this.rh) / 2.0 + this.fy;
    }
}

