/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant.ui;

import com.kodaro.tenant.BInvoice;
import com.kodaro.tenant.ui.BConsolidatedMeters;
import com.tridium.hx.px.BHxWidgetShell;
import com.tridium.pdf.BPxViewToPdf;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.baja.agent.BAbstractPxView;
import javax.baja.agent.BPxView;
import javax.baja.file.ExportOp;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.workbench.BWbEditor;

public class BInvoiceExportButton
extends BButton {
    public static final Type TYPE = Sys.loadType(BInvoiceExportButton.class);

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setCommand(new CmdExport(), false, false);
    }

    protected void exportInvoice() {
        BInvoice inv = this.get();
        try {
            File bajaTemp = new File(Sys.getBajaHome(), "temp");
            bajaTemp.mkdirs();
            File file = File.createTempFile("temp", ".pdf", bajaTemp);
            file.deleteOnExit();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            BConsolidatedMeters.invoice = inv;
            BPxView view = inv.getInvoiceExport();
            ExportOp op = ExportOp.make((OrdTarget)inv.getNavOrd().resolve((BObject)this), (OutputStream)out);
            BPxViewToPdf exporter = new BPxViewToPdf((BAbstractPxView)view);
            exporter.export(op);
            out.close();
            String path = BInvoiceExportButton.formatPath(file);
            if (System.getProperty("os.name").equalsIgnoreCase("linux")) {
                Runtime.getRuntime().exec("gnome-open " + path);
            } else {
                Runtime.getRuntime().exec("cmd.exe /c start " + path);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    protected BInvoice get() {
        for (BComplex c = this.getParent(); c != null; c = c.getParent()) {
            if (c instanceof BWbEditor) {
                BInvoice ret = (BInvoice)((BWbEditor)c).getCurrentValue();
                ret.lease(1, 1000L);
                return ret;
            }
            if (!(c instanceof BHxWidgetShell)) continue;
            BInvoice ret = (BInvoice)((BHxWidgetShell)c).getActiveOrdTarget().get();
            ret.lease(1, 1000L);
            return ret;
        }
        return null;
    }

    private static String formatPath(File file) throws Exception {
        String path = "";
        String[] s = TextUtil.split((String)file.getCanonicalPath(), (char)'\\');
        for (int i = 0; i < s.length; ++i) {
            if (i > 0) {
                path = path + "\\";
            }
            path = s[i].indexOf(" ") != -1 ? path + "\"" + s[i] + "\"" : path + s[i];
        }
        return path;
    }

    private class CmdExport
    extends Command {
        CmdExport() {
            super((BWidget)BInvoiceExportButton.this, "Export Invoice");
        }

        public CommandArtifact doInvoke() {
            BInvoiceExportButton.this.exportInvoice();
            return null;
        }
    }
}

