/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant.ui;

import javax.baja.gx.BImage;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;

public class BNeedle
extends BWidget {
    public static final Property clockwise = BNeedle.newProperty((int)0, (boolean)true, null);
    public static final Property minValue = BNeedle.newProperty((int)0, (double)0.0, null);
    public static final Property minAngle = BNeedle.newProperty((int)0, (int)270, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)360.0));
    public static final Property maxValue = BNeedle.newProperty((int)0, (int)100, null);
    public static final Property maxAngle = BNeedle.newProperty((int)0, (int)90, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)360.0));
    public static final Property needle = BNeedle.newProperty((int)0, (BValue)BImage.NULL, null);
    public static final Property value = BNeedle.newProperty((int)0, (double)0.0, null);
    public static final Type TYPE = Sys.loadType(BNeedle.class);
    private static BIcon icon = BIcon.make((String)"module://kodarotenant/img/dial.png");
    double angle;
    BImage fg;
    double fw;
    double fh;
    double fx;
    double fy;
    BImage rot;
    double rw;
    double rh;
    double rx;
    double ry;

    public boolean getClockwise() {
        return this.getBoolean(clockwise);
    }

    public void setClockwise(boolean v) {
        this.setBoolean(clockwise, v, null);
    }

    public double getMinValue() {
        return this.getDouble(minValue);
    }

    public void setMinValue(double v) {
        this.setDouble(minValue, v, null);
    }

    public double getMinAngle() {
        return this.getDouble(minAngle);
    }

    public void setMinAngle(double v) {
        this.setDouble(minAngle, v, null);
    }

    public double getMaxValue() {
        return this.getDouble(maxValue);
    }

    public void setMaxValue(double v) {
        this.setDouble(maxValue, v, null);
    }

    public double getMaxAngle() {
        return this.getDouble(maxAngle);
    }

    public void setMaxAngle(double v) {
        this.setDouble(maxAngle, v, null);
    }

    public BImage getNeedle() {
        return (BImage)this.get(needle);
    }

    public void setNeedle(BImage v) {
        this.set(needle, (BValue)v, null);
    }

    public double getValue() {
        return this.getDouble(value);
    }

    public void setValue(double v) {
        this.setDouble(value, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context cx) {
        this.rotate();
    }

    public void computePreferredSize() {
        this.fw = this.fg.getWidth();
        this.fh = this.fg.getHeight();
        double max = Math.max(this.fw, this.fh);
        this.setPreferredSize(max, max);
    }

    public void doLayout(BWidget[] kids) {
        this.fx = (this.getWidth() - this.fw) / 2.0;
        this.fy = (this.getHeight() - this.fh) / 2.0;
        this.rx = (this.fw - this.rw) / 2.0 + this.fx;
        this.ry = (this.fh - this.rh) / 2.0 + this.fy;
    }

    public BIcon getIcon() {
        return icon;
    }

    public void paint(Graphics g) {
        g.drawImage(this.rot, this.rx, this.ry);
    }

    public void started() {
        this.fg = this.getNeedle();
        this.rotate();
    }

    public double getAngle() {
        double anglesUsed = 0.0;
        anglesUsed = this.getClockwise() ? (this.getMinAngle() > this.getMaxAngle() ? this.getMaxAngle() + (360.0 - this.getMinAngle()) : this.getMaxAngle() - this.getMinAngle()) : (this.getMinAngle() > this.getMaxAngle() ? this.getMinAngle() - this.getMaxAngle() : this.getMinAngle() + (360.0 - this.getMaxAngle()));
        double unitsUsed = this.getMaxValue() - this.getMinValue();
        double anglesPerUnit = anglesUsed / unitsUsed;
        double value = this.getValue();
        if (value < this.getMinValue()) {
            value = this.getMinValue();
        }
        if (value > this.getMaxValue()) {
            value = this.getMaxValue();
        }
        double angle = (value -= this.getMinValue()) * anglesPerUnit;
        if (this.getClockwise()) {
            angle = (this.getMinAngle() + angle) % 360.0;
        } else {
            angle = this.getMinAngle() - angle;
            if (angle < 0.0) {
                angle = 360.0 + angle;
            }
        }
        return angle;
    }

    public void rotate() {
        if (this.fg == null) {
            return;
        }
        this.angle = this.getAngle();
        if (this.angle == 0.0 || this.angle == 360.0) {
            this.rot = this.fg;
            this.rw = this.fw;
            this.rh = this.fh;
            this.doLayout(null);
            this.repaint();
            return;
        }
        BTransform t = BTransform.makeRotate((double)this.angle);
        this.rot = this.fg.transform(t);
        this.rw = this.rot.getWidth();
        this.rh = this.rot.getHeight();
        this.doLayout(null);
        this.repaint();
    }
}

