/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant.ui;

import com.kodaro.tenant.BTbsUser;
import com.kodaro.tenant.BTenantBilling;
import com.kodaro.tenant.ui.BTbsUserFE;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.naming.SlotPath;
import javax.baja.security.BPasswordCache;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.workbench.view.BWbComponentView;

public class BPropertyManagerList_Orig
extends BWbComponentView {
    public static final Action deleteRows = BPropertyManagerList_Orig.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BPropertyManagerList_Orig.class);
    static final BImage imgAdd = BImage.make((BIcon)BIcon.std((String)"add.png"));
    static final BImage imgDelete = BImage.make((BIcon)BIcon.std((String)"delete.png"));
    static final BImage imgEdit = BImage.make((BIcon)BIcon.std((String)"edit.png"));
    BButton butAdd;
    BButton butEdit;
    BButton butDel;
    BTbsUser[] users;
    BTable table;
    BTenantBilling owner;

    public void deleteRows() {
        this.invoke(deleteRows, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doAddRow() {
        BTextField text = new BTextField();
        text.setVisibleColumns(20);
        BFlowPane fp = new BFlowPane();
        fp.add(null, (BValue)new BLabel("Login:"));
        fp.add(null, (BValue)text);
        int ret = BDialog.open((BWidget)this, (String)"New User", (Object)fp, (int)3);
        if (ret == 1) {
            try {
                String name = SlotPath.escape((String)text.getText());
                this.owner.addUser(BString.make((String)name));
                this.table.getSelection().deselectAll();
                this.users = (BTbsUser[])this.owner.getUsers().getChildren(BTbsUser.class);
                this.table.getModel().updateTable();
                int i = this.users.length;
                while (--i >= 0) {
                    if (!this.users[i].getName().equals(name)) continue;
                    this.table.getSelection().select(i);
                    this.doEditRow();
                }
            }
            catch (Exception x) {
                if (x instanceof BajaRuntimeException) {
                    BDialog.error((BWidget)this, (String)"Error", (Object)x.getCause().getMessage(), (Throwable)x);
                }
                BDialog.error((BWidget)this, (String)"Error", (Object)x.toString(), (Throwable)x);
            }
        }
    }

    public void doDeleteRows() {
        int[] r = this.table.getSelection().getRows();
        if (r == null || r.length == 0) {
            return;
        }
        for (int i = 0; i < r.length; ++i) {
            this.owner.removeUser(BString.make((String)this.users[r[i]].getName()));
        }
        this.table.getSelection().deselectAll();
        this.users = (BTbsUser[])this.owner.getUsers().getChildren(BTbsUser.class);
        this.table.getModel().updateTable();
        if (this.table.getSelection().getRowCount() == 1) {
            this.butEdit.setEnabled(true);
        } else {
            this.butEdit.setEnabled(false);
        }
    }

    public void doEditRow() {
        BTbsUser user = this.users[this.table.getSelection().getRow()];
        user = (BTbsUser)user.newCopy(true);
        BTbsUserFE fe = new BTbsUserFE();
        fe.showManager(false);
        fe.loadValue((BObject)user);
        int ret = BDialog.open((BWidget)this, (String)"Edit User", (Object)((Object)fe), (int)3);
        if (ret == 1) {
            try {
                user = (BTbsUser)fe.saveValue();
                this.owner.lease();
                user.setHomePage(this.owner.getHomePage());
                BTbsUser tableUser = this.users[this.table.getSelection().getRow()];
                BComponent c = new BComponent();
                c.add(tableUser.getName(), (BValue)user);
                this.owner.updateUser(c);
                tableUser.setFullName(user.getFullName());
                tableUser.setEnabled(user.getEnabled());
                tableUser.setExpiration(user.getExpiration());
                BPasswordCache tableUserPw = (BPasswordCache)tableUser.getAuthenticator();
                BPasswordCache userPw = (BPasswordCache)user.getAuthenticator();
                tableUserPw.setPassword(userPw.getPassword());
                System.out.println("managmerList Setting Roles: " + user.getRoles());
                System.out.println("User: " + (Object)((Object)tableUser));
                tableUser.setRoles(user.getRoles());
                tableUser.setHomePage(this.owner.getHomePage());
                this.table.getModel().updateTable();
            }
            catch (Exception x) {
                if (x instanceof BajaRuntimeException) {
                    BDialog.error((BWidget)this, (String)"Error", (Object)x.getCause().getMessage(), (Throwable)x);
                }
                BDialog.error((BWidget)this, (String)"Error", (Object)x.toString(), (Throwable)x);
            }
        }
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.owner = (BTenantBilling)value;
        this.users = (BTbsUser[])this.owner.getUsers().getChildren(BTbsUser.class);
        this.setContent(this.makeTable());
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        return value;
    }

    private BWidget makeTable() {
        BEdgePane ep = new BEdgePane();
        this.table = new BTable((TableModel)new Model(), (TableController)new Controller());
        this.table.setOptionsButtonVisible(false);
        ep.setCenter((BWidget)this.table);
        this.butAdd = new BButton((Command)new CmdAdd());
        this.butAdd.setButtonStyle(BButtonStyle.toolBar);
        this.butAdd.setBackground(BBrush.makeImage((BImage)BImage.NULL));
        this.butEdit = new BButton((Command)new CmdEdit());
        this.butEdit.setButtonStyle(BButtonStyle.toolBar);
        this.butEdit.setBackground(BBrush.makeImage((BImage)BImage.NULL));
        this.butEdit.setEnabled(false);
        this.butDel = new BButton((Command)new CmdDelete());
        this.butDel.setButtonStyle(BButtonStyle.toolBar);
        this.butDel.setBackground(BBrush.makeImage((BImage)BImage.NULL));
        BGridPane gp = new BGridPane(3);
        gp.setUniformColumnWidth(true);
        gp.setHalign(BHalign.center);
        gp.add(null, (BValue)this.butAdd);
        gp.add(null, (BValue)this.butEdit);
        gp.add(null, (BValue)this.butDel);
        ep.setBottom((BWidget)gp);
        return ep;
    }

    private class Model
    extends TableModel {
        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Username";
                }
                case 1: {
                    return "Full Name";
                }
                case 2: {
                    return "Enabled";
                }
                case 3: {
                    return "Expires";
                }
            }
            throw new IllegalArgumentException("Unexpected column: " + col);
        }

        public int getRowCount() {
            if (BPropertyManagerList_Orig.this.users == null) {
                return 0;
            }
            return BPropertyManagerList_Orig.this.users.length;
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return SlotPath.unescape((String)BPropertyManagerList_Orig.this.users[row].getName());
                }
                case 1: {
                    return BPropertyManagerList_Orig.this.users[row].getFullName();
                }
                case 2: {
                    if (BPropertyManagerList_Orig.this.users[row].getEnabled()) {
                        return "Yes";
                    }
                    return "No";
                }
                case 3: {
                    if (BPropertyManagerList_Orig.this.users[row].getExpiration().isNull()) {
                        return "Never";
                    }
                    return BPropertyManagerList_Orig.this.users[row].getExpiration();
                }
            }
            throw new IllegalArgumentException("Unexpected column: " + col);
        }
    }

    private class CmdEdit
    extends Command {
        CmdEdit() {
            super((BWidget)BPropertyManagerList_Orig.this, "Edit", imgEdit, null, null);
        }

        public CommandArtifact doInvoke() {
            BPropertyManagerList_Orig.this.doEditRow();
            return null;
        }
    }

    private class CmdDelete
    extends Command {
        CmdDelete() {
            super((BWidget)BPropertyManagerList_Orig.this, "Delete", imgDelete, null, null);
        }

        public CommandArtifact doInvoke() {
            BPropertyManagerList_Orig.this.doDeleteRows();
            return null;
        }
    }

    private class CmdAdd
    extends Command {
        CmdAdd() {
            super((BWidget)BPropertyManagerList_Orig.this, "Add", imgAdd, null, null);
        }

        public CommandArtifact doInvoke() {
            BPropertyManagerList_Orig.this.doAddRow();
            return null;
        }
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        protected void backgroundPopup(BMouseEvent e) {
            BMenu menu = new BMenu();
            menu.add(null, (Command)new CmdAdd());
            if (BPropertyManagerList_Orig.this.table.getSelection().getRowCount() > 0) {
                menu.add(null, (Command)new CmdDelete());
            }
            menu.open((BWidget)this.getTable(), e.getX(), e.getY());
        }

        protected void cellDoubleClicked(BMouseEvent e, int r, int c) {
            BPropertyManagerList_Orig.this.doEditRow();
        }

        protected void cellPopup(BMouseEvent e, int row, int column) {
            BMenu menu = new BMenu();
            if (BPropertyManagerList_Orig.this.table.getSelection().getRowCount() == 1) {
                menu.add(null, (Command)new CmdEdit());
            }
            menu.add(null, (Command)new CmdAdd());
            menu.add(null, (Command)new CmdDelete());
            menu.open((BWidget)this.getTable(), e.getX(), e.getY());
        }

        public void mousePressed(BMouseEvent e) {
            if (BPropertyManagerList_Orig.this.table.getSelection().getRowCount() == 1) {
                BPropertyManagerList_Orig.this.butEdit.setEnabled(true);
            } else {
                BPropertyManagerList_Orig.this.butEdit.setEnabled(false);
            }
            super.mousePressed(e);
        }

        public void mouseReleased(BMouseEvent e) {
            if (BPropertyManagerList_Orig.this.table.getSelection().getRowCount() == 1) {
                BPropertyManagerList_Orig.this.butEdit.setEnabled(true);
            } else {
                BPropertyManagerList_Orig.this.butEdit.setEnabled(false);
            }
            super.mouseReleased(e);
        }
    }
}

