/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant.util;

import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BComplexTable
extends BComponent
implements BITable {
    public static final Type TYPE = Sys.loadType(BComplexTable.class);
    private Cols cols;
    private BComplex[] objects;
    private BFacets tableFacets = BFacets.make((String)"precision", (BIDataValue)BDouble.make((double)2.0));

    public Type getType() {
        return TYPE;
    }

    public BComplexTable() {
    }

    public BComplexTable(BComplex proto, BComplex[] objects) {
        this.objects = objects;
        int len = 0;
        if (objects != null) {
            len = objects.length;
        }
        for (int i = 0; i < len; ++i) {
            this.add(null, (BValue)objects[i]);
        }
        Property[] props = proto.getPropertiesArray();
        len = props.length;
        Column[] c = new Col[len];
        for (int i = 0; i < len; ++i) {
            c[i] = new Col(props[i]);
        }
        this.cols = new Cols(c);
    }

    public TableCursor cursor() {
        return new MyCursor();
    }

    public BObject get(int i) {
        return this.row(i);
    }

    public BObject get(int row, Column col) {
        BComplex c = this.row(row);
        BValue ret = c.get(col.getName());
        return ret;
    }

    public boolean getBoolean(int row, Column col) {
        BComplex c = this.row(row);
        return c.getBoolean(this.prop(c, col));
    }

    public ColumnList getColumns() {
        return this.getCols();
    }

    public double getDouble(int row, Column col) {
        BComplex c = this.row(row);
        return c.getDouble(this.prop(c, col));
    }

    public BFacets getFacets(int row, Column col) {
        BComplex c = this.row(row);
        return c.getSlotFacets((Slot)this.prop(c, col));
    }

    public int getFlags(int row, Column col) {
        BComplex c = this.row(row);
        return c.getFlags((Slot)this.prop(c, col));
    }

    public float getFloat(int row, Column col) {
        BComplex c = this.row(row);
        return c.getFloat(this.prop(c, col));
    }

    public int getInt(int row, Column col) {
        BComplex c = this.row(row);
        return c.getInt(this.prop(c, col));
    }

    public long getLong(int row, Column col) {
        BComplex c = this.row(row);
        return c.getLong(this.prop(c, col));
    }

    public String getString(int row, Column col) {
        BComplex c = this.row(row);
        return c.getString(this.prop(c, col));
    }

    public BFacets getTableFacets() {
        return this.tableFacets;
    }

    public BObject[] list() {
        return this.getObjects();
    }

    public BObject[] list(BObject[] in) {
        BComplex[] e = this.getObjects();
        if (in.length < e.length) {
            return e;
        }
        System.arraycopy(e, 0, in, 0, e.length);
        return in;
    }

    public void setTableFacets(BFacets f) {
        this.tableFacets = f;
    }

    public int size() {
        return this.getObjects().length;
    }

    public BITable toList() {
        return this;
    }

    public BITable toTable() {
        return this;
    }

    private Cols getCols() {
        if (this.cols == null) {
            BComplex proto = this.getObjects()[0];
            Property[] props = proto.getPropertiesArray();
            int len = props.length;
            Column[] c = new Col[len];
            for (int i = 0; i < len; ++i) {
                c[i] = new Col(props[i]);
            }
            this.cols = new Cols(c);
        }
        return this.cols;
    }

    private BComplex[] getObjects() {
        if (this.objects == null) {
            this.objects = (BComplex[])this.getChildren(BComplex.class);
        }
        return this.objects;
    }

    private Property prop(BComplex row, Column prop) {
        return row.getProperty(prop.getName());
    }

    private BComplex row(int row) {
        return this.getObjects()[row];
    }

    private static class Cols
    implements ColumnList {
        Column[] columns;

        Cols(Column[] columns) {
            this.columns = columns;
        }

        public Column get(int i) {
            return this.columns[i];
        }

        public Column get(String name) {
            int i = this.indexOf(name);
            if (i >= 0) {
                return this.columns[i];
            }
            return null;
        }

        public int indexOf(String name) {
            int i = this.columns.length;
            while (--i >= 0) {
                if (!this.columns[i].getName().equals(name)) continue;
                return i;
            }
            return -1;
        }

        public Column[] list() {
            return this.columns;
        }

        public int size() {
            return this.columns.length;
        }
    }

    private static class Col
    implements Column {
        Property p;
        String display;

        Col(Property p) {
            this.p = p;
            this.display = p.getDefaultDisplayName(null);
        }

        Col(String display, Property p) {
            this.p = p;
            this.display = display;
        }

        public String getDisplayName(Context cx) {
            return this.display;
        }

        public BFacets getFacets() {
            return this.p.getFacets();
        }

        public int getFlags() {
            return this.p.getDefaultFlags();
        }

        public String getName() {
            return this.p.getName();
        }

        public Type getType() {
            return this.p.getType();
        }
    }

    private class Row
    implements javax.baja.collection.Row {
        private BComplex obj;

        public Row(BComplex obj) {
            this.obj = obj;
        }

        public BITable getTable() {
            return null;
        }

        public BIObject rowObject() {
            return this.obj;
        }

        public BIObject cell(Column column) {
            return this.obj.get(column.getName());
        }

        public int getCellFlags(Column column) {
            return 0;
        }

        public BFacets getCellFacets(Column column) {
            return null;
        }

        public javax.baja.collection.Row safeCopy() {
            return new Row(this.obj);
        }
    }

    private class MyCursor
    implements TableCursor {
        SlotCursor inner;

        MyCursor() {
            this.inner = BComplexTable.this.getProperties();
        }

        public BObject get(Column col) {
            BComplex c = this.get().asComplex();
            BValue ret = c.get(BComplexTable.this.prop(c, col));
            return ret;
        }

        public boolean getBoolean(Column col) {
            BComplex c = this.get().asComplex();
            return c.getBoolean(BComplexTable.this.prop(c, col));
        }

        public double getDouble(Column col) {
            BComplex c = this.get().asComplex();
            return c.getDouble(BComplexTable.this.prop(c, col));
        }

        public BFacets getFacets(Column col) {
            BComplex c = this.get().asComplex();
            return c.getSlotFacets((Slot)BComplexTable.this.prop(c, col));
        }

        public int getFlags(Column col) {
            BComplex c = this.get().asComplex();
            return c.getFlags((Slot)BComplexTable.this.prop(c, col));
        }

        public float getFloat(Column col) {
            BComplex c = this.get().asComplex();
            return c.getFloat(BComplexTable.this.prop(c, col));
        }

        public int getInt(Column col) {
            BComplex c = this.get().asComplex();
            return c.getInt(BComplexTable.this.prop(c, col));
        }

        public long getLong(Column col) {
            BComplex c = this.get().asComplex();
            return c.getLong(BComplexTable.this.prop(c, col));
        }

        public String getString(Column col) {
            BComplex c = this.get().asComplex();
            return c.getString(BComplexTable.this.prop(c, col));
        }

        public BITable getTable() {
            return BComplexTable.this;
        }

        public BObject get() {
            return this.inner.get();
        }

        public Context getContext() {
            return this.inner.getContext();
        }

        public boolean next() {
            return this.inner.next();
        }

        public boolean next(Class clazz) {
            return this.inner.next(clazz);
        }

        public boolean nextComponent() {
            return this.inner.nextComponent();
        }

        public void close() {
        }

        public Row row() {
            Row row = new Row((BComplex)this.inner.get());
            return row;
        }
    }
}

