/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BDateTime
extends BSimple {
    public static final BDateTime DEFAULT = new BDateTime(1L);
    public static final Type TYPE = Sys.loadType(BDateTime.class);
    private long value;

    public static BDateTime make(BAbsTime t) {
        return new BDateTime(t.getMillis());
    }

    public static BDateTime make(int year, BMonth month, int day) {
        BAbsTime t = BAbsTime.make((int)year, (BMonth)month, (int)day);
        return new BDateTime(t.getMillis());
    }

    public static BDateTime make(long value) {
        return new BDateTime(value);
    }

    public static BDateTime make(String value) {
        return BDateTime.make(Long.parseLong(value));
    }

    private BDateTime(long value) {
        this.value = value;
    }

    public long getLong() {
        return this.value;
    }

    public long compareTo(Object obj) {
        long a = this.value;
        long b = ((BNumber)obj).getLong();
        if (a == b) {
            return 0L;
        }
        if (a < b) {
            return -1L;
        }
        return 1L;
    }

    public BObject decode(DataInput in) throws IOException {
        return BDateTime.make(in.readLong());
    }

    public BObject decodeFromString(String s) throws IOException {
        try {
            return BDateTime.make(s);
        }
        catch (RuntimeException e) {
            throw new IOException("Invalid number: " + s);
        }
    }

    public void encode(DataOutput out) throws IOException {
        out.writeLong(this.value);
    }

    public String encodeToString() throws IOException {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return (int)this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BDateTime) {
            return ((BDateTime)((Object)obj)).value == this.value;
        }
        return false;
    }

    public BAbsTime toAbsTime() {
        return BAbsTime.make((long)this.value);
    }

    public String toString(Context cx) {
        StringBuffer buf = new StringBuffer();
        BAbsTime t = this.toAbsTime();
        buf.append(t.getDay()).append(' ');
        buf.append(t.getMonth().getShortDisplayTag(cx)).append(' ');
        buf.append(t.getYear());
        return buf.toString();
    }

    public static String toString(long value, Context cx) {
        return Long.toString(value);
    }

    public Type getType() {
        return TYPE;
    }
}

