/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant.util;

import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BRuntimeHours
extends BComponent {
    public static final Property out = BRuntimeHours.newProperty((int)9, (BValue)new BStatusNumeric(0.0), null);
    public static final Property in = BRuntimeHours.newProperty((int)10, (BValue)new BStatusBoolean(false), null);
    public static final Property facets = BRuntimeHours.newProperty((int)0, (BValue)BFacets.NULL, null);
    public static final Property lastOn = BRuntimeHours.newProperty((int)6, (BValue)BAbsTime.NULL, null);
    public static final Action execute = BRuntimeHours.newAction((int)0, null);
    public static final Action reset = BRuntimeHours.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BRuntimeHours.class);
    private static BIcon icon = BIcon.std((String)"clock.png");
    private static double millisHour = 3600000.0;
    private boolean steady = false;
    private Clock.Ticket ticket;

    public BStatusNumeric getOut() {
        return (BStatusNumeric)this.get(out);
    }

    public void setOut(BStatusNumeric v) {
        this.set(out, (BValue)v, null);
    }

    public BStatusBoolean getIn() {
        return (BStatusBoolean)this.get(in);
    }

    public void setIn(BStatusBoolean v) {
        this.set(in, (BValue)v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BAbsTime getLastOn() {
        return (BAbsTime)this.get(lastOn);
    }

    public void setLastOn(BAbsTime v) {
        this.set(lastOn, (BValue)v, null);
    }

    public void execute() {
        this.invoke(execute, null, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void atSteadyState() {
        this.steady = true;
        this.inputChanged();
    }

    public void changed(Property p, Context cx) {
        if (p == in && this.steady) {
            this.inputChanged();
        }
        super.changed(p, cx);
    }

    public void doExecute() {
        double millis;
        if (!this.steady) {
            return;
        }
        BAbsTime now = Clock.time();
        BAbsTime last = this.getLastOn();
        if (!last.isNull() && (millis = (double)(now.getMillis() - last.getMillis())) > 0.0 && millis < millisHour) {
            double current = this.getOut().getValue();
            this.setOut(new BStatusNumeric(current += millis / millisHour));
        }
        if (this.isOn()) {
            this.setLastOn(now);
        } else {
            this.setLastOn(BAbsTime.NULL);
        }
    }

    public void doReset() {
        this.setLastOn(BAbsTime.NULL);
        this.setOut(new BStatusNumeric(0.0));
        this.inputChanged();
    }

    public BIcon getIcon() {
        return icon;
    }

    public BFacets getSlotFacets(Slot s) {
        if (s == in || s == out) {
            return this.getFacets();
        }
        return super.getSlotFacets(s);
    }

    public void started() throws Exception {
        this.steady = false;
        super.started();
        if (Sys.atSteadyState()) {
            this.atSteadyState();
        }
    }

    public void stopped() throws Exception {
        this.execute();
        this.steady = false;
        this.setLastOn(BAbsTime.NULL);
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        super.stop();
    }

    private void inputChanged() {
        this.execute();
        if (this.ticket != null) {
            this.ticket.cancel();
            this.ticket = null;
        }
        if (this.isOn()) {
            this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.make((long)30000L), (Action)execute, null);
        }
    }

    private boolean isOn() {
        BStatusBoolean bool = this.getIn();
        if (!bool.getStatus().isValid()) {
            return false;
        }
        return bool.getBoolean();
    }
}

