/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant.util;

import com.kodaro.tenant.util.BTbsObject;
import com.kodaro.tenant.util.PollScheduler;
import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BTbsPollScheduler
extends BComponent {
    public static final Property fastCount = BTbsPollScheduler.newProperty((int)1, (int)0, null);
    public static final Property normalCount = BTbsPollScheduler.newProperty((int)1, (int)0, null);
    public static final Property slowCount = BTbsPollScheduler.newProperty((int)1, (int)0, null);
    public static final Type TYPE = Sys.loadType(BTbsPollScheduler.class);
    private static PollScheduler fast;
    private static PollScheduler normal;
    private static PollScheduler slow;

    public int getFastCount() {
        return this.getInt(fastCount);
    }

    public void setFastCount(int v) {
        this.setInt(fastCount, v, null);
    }

    public int getNormalCount() {
        return this.getInt(normalCount);
    }

    public void setNormalCount(int v) {
        this.setInt(normalCount, v, null);
    }

    public int getSlowCount() {
        return this.getInt(slowCount);
    }

    public void setSlowCount(int v) {
        this.setInt(slowCount, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isNavChild() {
        return false;
    }

    public void subscribe(BTbsObject obj) {
        switch (obj.getPollFrequency().getOrdinal()) {
            case 0: {
                fast.subscribe(obj);
                break;
            }
            case 1: {
                normal.subscribe(obj);
                break;
            }
            case 2: {
                slow.subscribe(obj);
            }
        }
        this.updateCounts();
    }

    public void updateCounts() {
        this.setFastCount(fast.count());
        this.setNormalCount(normal.count());
        this.setSlowCount(slow.count());
    }

    public void unsubscribe(BTbsObject obj) {
        switch (obj.getPollFrequency().getOrdinal()) {
            case 0: {
                fast.unsubscribe(obj);
                break;
            }
            case 1: {
                normal.unsubscribe(obj);
                break;
            }
            case 2: {
                slow.unsubscribe(obj);
            }
        }
        this.updateCounts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void started() throws Exception {
        Class<BTbsPollScheduler> clazz = BTbsPollScheduler.class;
        synchronized (BTbsPollScheduler.class) {
            if (fast == null) {
                fast = new PollScheduler("TBS Fast Poller", 30000).start();
                normal = new PollScheduler("TBS Normal Poller", 60000).start();
                slow = new PollScheduler("TBS Slow Poller", 900000).start();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            super.started();
            return;
        }
    }
}

