/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteUtils {
    private static boolean bigEndian = false;
    private static final byte[] set = new byte[]{53, 13, 3, 41, 23, 17, 37};

    public static final void debug(byte[] b) {
        ByteUtils.debug(b, 0, b.length);
    }

    public static final void debug(byte[] b, int off, int len) {
        int end = off + len;
        for (int i = off; i < end; ++i) {
            System.out.print(Integer.toHexString(b[i] & 0xFF));
            System.out.print('.');
        }
        System.out.println();
    }

    public static byte[] getBytes(String s) {
        int len = s.length();
        int[] r = new int[20];
        int n = 0;
        int i = len;
        while (--i >= 0) {
            n += s.charAt(i);
        }
        int j = 0;
        int i2 = len;
        while (--i2 >= 0) {
            int n2 = j++;
            r[n2] = r[n2] + s.charAt(i2) * set[(n + i2) % 7];
            if (j < 20) continue;
            j = 0;
        }
        StringBuffer buf = new StringBuffer();
        j = 0;
        int i3 = 20;
        while (--i3 >= 0) {
            if (j > 0 && j % 4 == 0) {
                buf.append('-');
            }
            buf.append((char)(r[i3] % 26 + 65));
            ++j;
        }
        return buf.toString().getBytes();
    }

    public static String readAscii(byte[] buf, int off, int len) {
        StringBuffer sb = new StringBuffer();
        while (--len >= 0) {
            sb.append((char)buf[off]);
            ++off;
        }
        return sb.toString();
    }

    public static float readFloat(byte[] buf, int off) {
        int i = ByteUtils.readInt(buf, off);
        return Float.intBitsToFloat(i);
    }

    public static float readFloat(InputStream in) throws IOException {
        int i = ByteUtils.readInt(in);
        return Float.intBitsToFloat(i);
    }

    public static int readInt(byte[] buf, int off) {
        if (bigEndian) {
            return (buf[off] & 0xFF) << 24 | (buf[++off] & 0xFF) << 16 | (buf[++off] & 0xFF) << 8 | (buf[++off] & 0xFF) << 0;
        }
        return (buf[off] & 0xFF) << 0 | (buf[++off] & 0xFF) << 8 | (buf[++off] & 0xFF) << 16 | (buf[++off] & 0xFF) << 24;
    }

    public static int readInt(InputStream in) throws IOException {
        byte[] buf = new byte[4];
        in.read(buf);
        return ByteUtils.readInt(buf, 0);
    }

    public static int readU16(byte[] buf, int off) {
        if (bigEndian) {
            return (buf[off] & 0xFF) << 8 | (buf[++off] & 0xFF) << 0;
        }
        return (buf[off] & 0xFF) << 0 | (buf[++off] & 0xFF) << 8;
    }

    public static int readU16(InputStream in) throws IOException {
        byte[] buf = new byte[2];
        in.read(buf);
        return ByteUtils.readU16(buf, 0);
    }

    public static long readU32(byte[] buf, int off) {
        if (bigEndian) {
            return (long)(buf[off] & 0xFF) << 24 | (long)(buf[++off] & 0xFF) << 16 | (long)(buf[++off] & 0xFF) << 8 | (long)(buf[++off] & 0xFF) << 0;
        }
        return (long)(buf[off] & 0xFF) << 0 | (long)(buf[++off] & 0xFF) << 8 | (long)(buf[++off] & 0xFF) << 16 | (long)(buf[++off] & 0xFF) << 24;
    }

    public static long readU32(InputStream in) throws IOException {
        byte[] buf = new byte[4];
        in.read(buf);
        return ByteUtils.readU32(buf, 0);
    }

    public static void writeFloat(float f, byte[] b, int off) {
        int i = Float.floatToIntBits(f);
        ByteUtils.writeInt(i, b, off);
    }

    public static void writeFloat(float f, OutputStream out) throws IOException {
        int i = Float.floatToIntBits(f);
        ByteUtils.writeInt(i, out);
    }

    public static void writeInt(int v, byte[] buf, int off) {
        if (bigEndian) {
            buf[off] = (byte)(v >>> 24 & 0xFF);
            buf[++off] = (byte)(v >>> 16 & 0xFF);
            buf[++off] = (byte)(v >>> 8 & 0xFF);
            buf[++off] = (byte)(v >>> 0 & 0xFF);
        } else {
            buf[off] = (byte)(v >>> 0 & 0xFF);
            buf[++off] = (byte)(v >>> 8 & 0xFF);
            buf[++off] = (byte)(v >>> 16 & 0xFF);
            buf[++off] = (byte)(v >>> 24 & 0xFF);
        }
    }

    public static void writeInt(int v, OutputStream out) throws IOException {
        if (bigEndian) {
            out.write(v >>> 24 & 0xFF);
            out.write(v >>> 16 & 0xFF);
            out.write(v >>> 8 & 0xFF);
            out.write(v >>> 0 & 0xFF);
        } else {
            out.write(v >>> 0 & 0xFF);
            out.write(v >>> 8 & 0xFF);
            out.write(v >>> 16 & 0xFF);
            out.write(v >>> 24 & 0xFF);
        }
    }

    public static void writeU16(int v, byte[] b, int off) {
        if (bigEndian) {
            b[off] = (byte)(v >>> 8 & 0xFF);
            b[++off] = (byte)(v >>> 0 & 0xFF);
        } else {
            b[off] = (byte)(v >>> 0 & 0xFF);
            b[++off] = (byte)(v >>> 8 & 0xFF);
        }
    }

    public static void writeU16(int v, OutputStream out) throws IOException {
        if (bigEndian) {
            out.write(v >>> 8 & 0xFF);
            out.write(v >>> 0 & 0xFF);
        } else {
            out.write(v >>> 0 & 0xFF);
            out.write(v >>> 8 & 0xFF);
        }
    }

    public static void writeU32(long v, byte[] b, int off) {
        if (bigEndian) {
            b[off] = (byte)(v >>> 24 & 0xFFL);
            b[++off] = (byte)(v >>> 16 & 0xFFL);
            b[++off] = (byte)(v >>> 8 & 0xFFL);
            b[++off] = (byte)(v >>> 0 & 0xFFL);
        } else {
            b[off] = (byte)(v >>> 0 & 0xFFL);
            b[++off] = (byte)(v >>> 8 & 0xFFL);
            b[++off] = (byte)(v >>> 16 & 0xFFL);
            b[++off] = (byte)(v >>> 24 & 0xFFL);
        }
    }

    public static void writeU32(long v, OutputStream out) throws IOException {
        if (bigEndian) {
            out.write((byte)(v >>> 24 & 0xFFL));
            out.write((byte)(v >>> 16 & 0xFFL));
            out.write((byte)(v >>> 8 & 0xFFL));
            out.write((byte)(v >>> 0 & 0xFFL));
        } else {
            out.write((byte)(v >>> 0 & 0xFFL));
            out.write((byte)(v >>> 8 & 0xFFL));
            out.write((byte)(v >>> 16 & 0xFFL));
            out.write((byte)(v >>> 24 & 0xFFL));
        }
    }
}

