/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant.util;

import com.kodaro.tenant.util.BTbsObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import javax.baja.log.Log;

public class PollScheduler
implements Runnable {
    private boolean alive = false;
    private String name;
    private int rate;
    private TreeSet subscriptions = new TreeSet(new MyComparator());
    private ArrayList queue = new ArrayList();

    public PollScheduler(String name, int rate) {
        this.name = name;
        this.rate = rate;
    }

    public int count() {
        return this.subscriptions.size();
    }

    public boolean isAlive() {
        return this.alive;
    }

    public synchronized boolean isSubscribed(Object o) {
        return this.subscriptions.contains(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.alive) {
            int size = this.queue.size();
            if (size == 0) {
                PollScheduler pollScheduler = this;
                synchronized (pollScheduler) {
                    try {
                        this.wait(this.rate);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    continue;
                }
            }
            for (int i = 0; i < size; ++i) {
                long next = System.currentTimeMillis() + (long)(this.rate / size);
                if (this.alive) {
                    block21: {
                        BTbsObject obj = null;
                        try {
                            obj = (BTbsObject)((Object)this.queue.get(i));
                            if (obj != null) {
                                obj.poll();
                            }
                        }
                        catch (Exception x) {
                            if (obj == null) break block21;
                            Log.getLog((String)"TenantEye").error(obj.toPathString(), (Throwable)x);
                        }
                    }
                    if (this.alive && (next -= System.currentTimeMillis()) > 1L) {
                        try {
                            Thread.sleep(next);
                        }
                        catch (Exception exception) {}
                    } else {
                        try {
                            Thread.yield();
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    return;
                }
                try {
                    size = this.queue.size();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized PollScheduler start() {
        if (this.alive) {
            return this;
        }
        this.alive = true;
        new Thread((Runnable)this, this.name).start();
        return this;
    }

    public synchronized void stop() {
        this.alive = false;
    }

    public synchronized void subscribe(BTbsObject r) {
        if (!this.subscriptions.contains((Object)r)) {
            this.subscriptions.add(r);
            this.queue.add(r);
            this.notifyAll();
        }
    }

    public synchronized void unsubscribeAll() {
        this.subscriptions.clear();
        this.queue.clear();
        this.notifyAll();
    }

    public synchronized void unsubscribe(BTbsObject r) {
        if (this.subscriptions.remove((Object)r)) {
            int i = this.queue.size();
            while (--i >= 0) {
                if (this.queue.get(i) != r) continue;
                this.queue.remove(i);
                return;
            }
        }
    }

    static class MyComparator
    implements Comparator {
        MyComparator() {
        }

        public int compare(Object o1, Object o2) {
            int h2;
            if (o1 == o2) {
                return 0;
            }
            int h1 = System.identityHashCode(o1);
            if (h1 > (h2 = System.identityHashCode(o2))) {
                return 1;
            }
            return -1;
        }
    }
}

