/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant.util;

import java.util.Vector;
import javax.baja.naming.SlotPath;

public class StringUtils {
    public static final String[] fields(String row) {
        StringBuffer buf = new StringBuffer(100);
        int len = row.length();
        Vector<String> v = new Vector<String>(100);
        char ch = '\u0000';
        for (int i = 0; i < len; ++i) {
            ch = row.charAt(i);
            if (ch < '!' || ch > '~') {
                if (buf.length() <= 0) continue;
                v.addElement(buf.toString());
                buf.setLength(0);
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            v.addElement(buf.toString());
        }
        len = v.size();
        Object[] ret = new String[len];
        if (len == 0) {
            return ret;
        }
        v.copyInto(ret);
        return ret;
    }

    public static final String[] fields(String row, char delim) {
        StringBuffer buf = new StringBuffer(100);
        int len = row.length();
        Vector<String> v = new Vector<String>(100);
        char ch = '\u0000';
        for (int i = 0; i < len; ++i) {
            ch = row.charAt(i);
            if (ch == delim) {
                if (buf.length() <= 0) continue;
                v.addElement(buf.toString());
                buf.setLength(0);
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            v.addElement(buf.toString());
        }
        len = v.size();
        Object[] ret = new String[len];
        if (len == 0) {
            return ret;
        }
        v.copyInto(ret);
        return ret;
    }

    public static String getAsciiChars(String s) {
        int len = s.length();
        StringBuffer buf = new StringBuffer(len);
        char ch = '\u0000';
        for (int i = 0; i < len; ++i) {
            ch = s.charAt(i);
            if (ch >= 'A' && ch <= 'Z') {
                buf.append(ch);
                continue;
            }
            if (ch >= 'a' && ch <= 'z') {
                buf.append(ch);
                continue;
            }
            if (ch < '0' || ch > '9') continue;
            buf.append(ch);
        }
        return buf.toString().trim();
    }

    public static final String getNumber(String src) {
        int len = src.length();
        StringBuffer buf = new StringBuffer();
        boolean hasDec = false;
        boolean hasDigits = false;
        boolean hasMinus = false;
        boolean hasExp = false;
        for (int i = 0; i < len; ++i) {
            char ch = src.charAt(i);
            if (ch == '-' && !hasMinus) {
                buf.append('-');
                hasMinus = true;
                continue;
            }
            if (ch == '.' && !hasDec) {
                buf.append(ch);
                hasDec = true;
                continue;
            }
            if (Character.isDigit(ch)) {
                buf.append(ch);
                hasDigits = true;
                continue;
            }
            if (!(ch != 'e' && ch != 'E' || hasExp)) {
                if (!hasDigits) continue;
                String sciNot = "e";
                if (i + 1 >= len) continue;
                char nextChar = src.charAt(i + 1);
                if (nextChar == '-' || nextChar == '+') {
                    if (i + 2 >= len) break;
                    sciNot = sciNot + nextChar;
                    nextChar = src.charAt(i + 2);
                    ++i;
                }
                if (!Character.isDigit(nextChar)) break;
                buf.append(sciNot);
                hasExp = true;
                continue;
            }
            if (hasDigits) break;
        }
        src = buf.toString();
        return src;
    }

    public static String makeValidName(String str) {
        String ret;
        if (SlotPath.isValidName((String)str)) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str);
        int j = buf.length();
        while (--j >= 0) {
            char ch = buf.charAt(j);
            if (Character.isIdentifierIgnorable(ch)) {
                buf.deleteCharAt(j);
                continue;
            }
            if (Character.isJavaIdentifierPart(ch)) continue;
            buf.deleteCharAt(j);
        }
        if (buf.length() == 0) {
            return null;
        }
        if (!Character.isJavaIdentifierStart(buf.charAt(0))) {
            buf.insert(0, '_');
        }
        if (!SlotPath.isValidName((String)(ret = buf.toString()))) {
            ret = SlotPath.escape((String)ret);
        }
        if (!SlotPath.isValidName((String)ret)) {
            return null;
        }
        return ret;
    }

    public static final String printable(String s) {
        int len = s.length();
        StringBuffer buf = new StringBuffer(len);
        char ch = '\u0000';
        for (int i = 0; i < len; ++i) {
            ch = s.charAt(i);
            if (ch < ' ' || ch > '~') {
                switch (ch) {
                    case ' ': {
                        buf.append(' ');
                        break;
                    }
                    case '\r': {
                        buf.append("<\\r>");
                        break;
                    }
                    case '\n': {
                        buf.append("<\\n>");
                        break;
                    }
                    case '\u001b': {
                        buf.append("<esc>");
                        break;
                    }
                    default: {
                        buf.append('<');
                        buf.append((int)ch);
                        buf.append('>');
                        break;
                    }
                }
                continue;
            }
            buf.append(ch);
        }
        return buf.toString().trim();
    }

    public static final String trim(String s) {
        int len = s.length();
        StringBuffer buf = new StringBuffer(len);
        char ch = '\u0000';
        for (int i = 0; i < len; ++i) {
            ch = s.charAt(i);
            if (ch < ' ' || ch > '~') {
                buf.append(' ');
                continue;
            }
            buf.append(ch);
        }
        return buf.toString().trim();
    }
}

