/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant.util;

import java.util.LinkedList;

public class ThreadPool {
    private boolean alive = true;
    private int idleThreads = 0;
    private int max = 5;
    private int min = 1;
    private String name = "TBS Thread";
    private int numThreads = 0;
    private LinkedList queue = new LinkedList();
    private static ThreadPool service;

    public ThreadPool() {
        this.max = Math.max(ThreadPool.getAvailableProcessors() * 2, 15);
    }

    public static ThreadPool getService() {
        if (service == null) {
            service = new ThreadPool();
        }
        return service;
    }

    public synchronized void enqueue(Runnable r) {
        this.queue.add(r);
        this.checkThreads();
        this.notify();
    }

    public static int getAvailableProcessors() {
        try {
            return Runtime.getRuntime().availableProcessors();
        }
        catch (Throwable throwable) {
            return 2;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLimits(int min, int max) {
        this.min = min;
        this.max = max;
    }

    protected void checkThreads() {
        if (this.idleThreads == 0 && this.numThreads < this.max) {
            ++this.numThreads;
            new MyThread(this.name).start();
        }
    }

    protected void finalize() throws Throwable {
        this.alive = false;
    }

    private Runnable dequeue() {
        if (this.queue.size() == 0) {
            return null;
        }
        return (Runnable)this.queue.remove(0);
    }

    private class MyThread
    extends Thread {
        public MyThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int attempts = 0;
                Runnable r = null;
                while (ThreadPool.this.alive) {
                    ThreadPool threadPool = ThreadPool.this;
                    synchronized (threadPool) {
                        ThreadPool.this.idleThreads++;
                        attempts = 0;
                        while (r == null && ThreadPool.this.alive) {
                            r = ThreadPool.this.dequeue();
                            if (r != null) continue;
                            if (++attempts > 4 && ThreadPool.this.numThreads > ThreadPool.this.min) {
                                ThreadPool.this.idleThreads--;
                                ThreadPool.this.numThreads--;
                                return;
                            }
                            try {
                                ThreadPool.this.wait(5000L);
                            }
                            catch (Exception exception) {}
                        }
                        ThreadPool.this.idleThreads--;
                        ThreadPool.this.notify();
                        ThreadPool.this.checkThreads();
                    }
                    if (r == null) continue;
                    r.run();
                    r = null;
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            ThreadPool threadPool = ThreadPool.this;
            synchronized (threadPool) {
                ThreadPool.this.numThreads--;
            }
        }
    }
}

