/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant.util;

import com.kodaro.tenant.util.WrapperException;
import java.lang.reflect.Method;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;

public class UserUtils {
    private static Method addUser = null;
    private static Method getUsers = null;
    private static Method removeUser = null;
    private static Class userService = null;

    public static boolean iskodaroUserService() {
        return UserUtils.iskodaroUserService(BUserService.getService());
    }

    public static boolean iskodaroUserService(BUserService svc) {
        try {
            if (userService == null) {
                BModule mod = Sys.loadModule((String)"kodarouser");
                if (mod == null) {
                    return false;
                }
                userService = mod.loadClass("com.kodaro.user.BkodaroUserService");
            }
            return userService.isInstance(svc);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void addUser(String[] path, String name, BUser user) {
        BUserService svc = BUserService.getService();
        if (!UserUtils.iskodaroUserService(svc)) {
            svc.add(name, (BValue)user);
            return;
        }
        try {
            if (addUser == null) {
                Class[] args = new Class[]{String[].class, String.class, BUser.class};
                addUser = svc.getClass().getMethod("addUser", args);
            }
            addUser.invoke((Object)svc, path, name, user);
        }
        catch (Exception x) {
            throw new WrapperException(x);
        }
    }

    public static BUser getUser(String name) {
        return BUserService.getService().getUser(name);
    }

    public static BUser[] getUsers(String[] path) {
        BUserService svc = BUserService.getService();
        if (!UserUtils.iskodaroUserService(svc)) {
            return (BUser[])svc.getChildren(BUser.class);
        }
        try {
            if (getUsers == null) {
                Class[] args = new Class[]{String[].class};
                getUsers = svc.getClass().getMethod("getUsers", args);
            }
            return (BUser[])getUsers.invoke((Object)svc, new Object[]{path});
        }
        catch (Exception x) {
            throw new WrapperException(x);
        }
    }

    public static void removeUser(String name) {
        BUserService svc = BUserService.getService();
        if (!UserUtils.iskodaroUserService(svc)) {
            svc.remove(name);
            return;
        }
        try {
            if (removeUser == null) {
                Class[] args = new Class[]{String.class};
                removeUser = svc.getClass().getMethod("removeUser", args);
            }
            removeUser.invoke((Object)svc, name);
        }
        catch (Exception x) {
            throw new WrapperException(x);
        }
    }
}

